% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InsiderTransactionsAPI.R
\name{get_insider_transactions_data}
\alias{get_insider_transactions_data}
\title{Get insider transactions data}
\usage{
get_insider_transactions_data(
  api_token,
  date_from = NULL,
  date_to = NULL,
  code = NULL,
  limit = NULL
)
}
\arguments{
\item{api_token}{The API token for authentication.}

\item{date_from}{date from with format Y-m-d}

\item{date_to}{date from with format Y-m-d}

\item{code}{to get the data only for Apple Inc (AAPL), use AAPL.US or AAPL ticker code.}

\item{limit}{the limit for entries per result, from 1 to 1000.}
}
\value{
A list containing the insider transactions data.
}
\description{
This function retrieves the insider transactions from the API.
}
\examples{
api_token <- "demo"
date_from <- "2017-09-10"
date_to <- "2017-09-12"
code <- "AAPL.US"
limit <- "150"
result <- get_insider_transactions_data(api_token, date_from, date_to, code, limit)

}
