% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StockMarketTickDataAPI.R
\name{get_stock_market_tick_data}
\alias{get_stock_market_tick_data}
\title{Get stock market tick data}
\usage{
get_stock_market_tick_data(
  api_token,
  symbol,
  from_timestamp,
  to_timestamp,
  limit = 2
)
}
\arguments{
\item{api_token}{The API token for authentication.}

\item{symbol}{consists of two parts: SYMBOL_NAME.EXCHANGE_ID. This API works only for US exchanges for the moment,
then you can use 'AAPL' or 'AAPL.US' to get the data as well for other US tickers.}

\item{from_timestamp}{use these parameters to filter data by datetime.
Parameters should be passed in UNIX time with UTC timezone,
for example, these values are correct: “from=1627896900&to=1630575300” and
correspond to ' 2021-08-02 09:35:00 ' and ' 2021-09-02 09:35:00 '.}

\item{to_timestamp}{use these parameters to filter data by datetime.}

\item{limit}{use ‘a’ for ascending dates (from old to new), ‘d’ for descending dates (from new to old).}
}
\value{
A list containing the stock market tick data.
}
\description{
This function retrieves stock market tick data from the API.
}
\examples{
api_token <- "demo"
from_timestamp <- "1627896900"
to_timestamp <- "1630575300"
symbol <- "AAPL"
limit <- 1
result <- get_stock_market_tick_data(api_token, symbol, from_timestamp, to_timestamp, limit)

}
