% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UpcomingEarningsAPI.R
\name{get_upcoming_earnings_data}
\alias{get_upcoming_earnings_data}
\title{Get upcoming earnings data}
\usage{
get_upcoming_earnings_data(
  api_token,
  from_date = NULL,
  to_date = NULL,
  symbols = NULL
)
}
\arguments{
\item{api_token}{The API token for authentication.}

\item{from_date}{Format: YYYY-MM-DD. The start date for earnings data, if not provided, today will be used.}

\item{to_date}{Format: YYYY-MM-DD. The end date for earnings data, if not provided, today + 7 days will be used.}

\item{symbols}{You can request specific symbols to get historical and upcoming data.}
}
\value{
A list containing the upcoming earnings data.
}
\description{
This function retrieves upcoming earnings data from the API.
}
\examples{
api_token <- "demo"
from_date <- "2017-09-10"
to_date <- "2017-09-12"
symbols <- "MS"
result <- get_upcoming_earnings_data(api_token, from_date, to_date, symbols)

}
