% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{cpve}
\alias{cpve}
\title{Cumulative Proportion of Variance Explained (CPVE)}
\usage{
cpve(mat, V, is.cov = FALSE)
}
\arguments{
\item{mat}{\code{matrix} or \code{Matrix}, the original data matrix \code{X} or \code{cov(X) = crossprod(X) / (nrow(X) - 1)}}

\item{V}{\code{matrix}, coefficients of linear transformation, e.g., loadings (in PCA).}

\item{is.cov}{\code{logical}, whether the input matrix is a covariance matrix or a Gram matrix.}
}
\value{
a \code{numeric} vector of length \code{ncol(V)}, the i-th value is the CPVE of the first i columns in \code{V}.
}
\description{
Calculate the CPVE.
}
\examples{
## use the "swiss" data
## find two sparse PCs
s.sca <- sca(swiss, 2, gamma = sqrt(ncol(swiss)))
ld <- loadings(s.sca)
cpve(as.matrix(swiss), ld)

}
\seealso{
\link{pve}
}
