% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handling.R
\name{[.epicontacts}
\alias{[.epicontacts}
\title{Subset epicontacts objects based on case identifiers}
\usage{
\method{[}{epicontacts}(x, i, j, k = TRUE, l = TRUE, contacts = c("both",
  "either", "from", "to"), ...)
}
\arguments{
\item{x}{An \code{\link{epicontacts}} object}

\item{i}{A character vector containing case ID to be retained in the
linelist; alternatively, an integer or logical vector used to subset the
rows of the \code{$linelist} component.}

\item{j}{A character vector containing case ID to be retained in the
contacts; alternatively, an integer or logical vector used to subset
the rows of the \code{$contacts} component.}

\item{k}{An integer, logical, or character vector subsetting the
supplementary columns of \code{x$linelist}, i.e. the columns after 'id';
i.e. \code{k=1} refers to the column immediately after 'id'.}

\item{l}{An integer, logical, or character vector subsetting the
supplementary columns of \code{x$contacts}, i.e. the columns after 'from'
and 'to'; i.e. \code{l=1} refers to the column immediately after 'to'.}

\item{contacts}{A character string indicating the rules for retaining
contacts when \code{j} indicates case IDs (see details).}

\item{...}{Not used (there for compatibility with generic).}
}
\description{
The "[" operator can be used to subset \code{\link{epicontacts}} objects,
retaining a specified set of case identifiers (\code{i} for the linelist,
\code{j} for contacts). Note that unlike most classical R objects, there is
no replacement method for \code{\link{epicontacts}} objects, i.e. no
operations such as \code{foo[i] <- bar}.
}
\details{
Details on the 'contacts' argument; possible values are:

\itemize{

\item 'both': contacts are retained only if both cases are in \code{j}

\item 'either': contacts are retained if at least one of the cases is in
\code{j}

\item 'from': contacts are retained only if the source ('from') is in
\code{j}

\item 'to': contacts are retained only if the recipient ('to') is in \code{j}
}
}
\examples{
if (require(outbreaks)) {
## build data
x <- make_epicontacts(ebola_sim$linelist, ebola_sim$contacts,
                       id = "case_id", to = "case_id", from = "infector",
                       directed = TRUE)

## subset first 10 linelist cases
x[1:10]

## same, remove contacts
x[1:10, j = FALSE]

## subset first 10 contacts
x[j = 1:10]

## remove the metadata
x[k = FALSE, j = FALSE]

## keep contacts where both cases are in linelist
x[j = get_id(x, "linelist"), contacts = "both"]

## keep contacts from a specific case '916d0a'
x[j = "916d0a", contacts = "from"]

## more complex: keep all cases and contacts with > 4 secondary contacts
## i) find cases to keep
temp <- table(x$contacts$from)
temp[temp > 4]
to.keep <- names(temp)[temp > 4]
to.keep

## subset the contacts
y <- x[j = to.keep, contacts = "either"]
y

## keep only relevant entries in the linelist
y <- thin(y)

## visualise result
plot(y)
}
}
\seealso{
\code{\link{thin}} to retain matching cases in linelist or contacts.
}
\author{
Thibaut Jombart (\email{thibautjombart@gmail.com})
}
