% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_epicontacts.R
\name{make_epicontacts}
\alias{make_epicontacts}
\alias{epicontacts}
\title{Read linelist and contact data}
\usage{
make_epicontacts(linelist, contacts, id = 1L, from = 1L, to = 2L,
  directed = FALSE)
}
\arguments{
\item{linelist}{a \link{data.frame} with at least one column providing unique
patient identifiers}

\item{contacts}{a \link{data.frame} that needs at least two columns
indicating patients between which cases take place; these need not be
referenced in the linelist}

\item{id}{an index or name indicating which column in \code{linelist}
contains unique identifiers; default is first column in \code{linelist}
data frame}

\item{from}{an index or name indicating which column in \code{contacts}
contains the first case of a contact}

\item{to}{an index or name indicating which column in \code{contacts}
contains the second case of a contact}

\item{directed}{a logical indicating if contacts are directed or not; default
is \code{FALSE} but note that contacts will be indicated as 'from' and
'to' even in non-directed contacts}
}
\value{
An \code{epicontacts} object in list format with three elements:

\itemize{
\item \code{linelist}: data.frame of cases with first column 'id'
containing character vector of unique identifiers

\item \code{contacts}: data.frame of contacts with first two columns named
'from' and 'to' indicating unique pairs of contact between individuals

\item \code{directed}: indicator as to whether or not the contacts are to be
considered directed or not
}
}
\description{
This function reads data stored as data.frame containing linelist (case
information, where each row corresponds to a unique patient), and contacts
between patients. Common identifiers should be used in the two data sources
for matching to be achieved.
}
\details{
An \code{epicontacts} object can be created from two components:
\itemize{
\item a linelist provided as a \code{data.frame} where columns are
different variables describing cases, and where each row is a different case.
and a contact list.

\item a contact list provided as a \code{data.frame} where each row contains
unique pairs of contacts with unique features of contact in columns. The line
list and contact list should share an identification scheme for individuals.
}
}
\examples{
if (require(outbreaks)) {
## make epicontacts object from simulated Ebola data
x <- make_epicontacts(ebola_sim$linelist, ebola_sim$contacts)

## test reordering of columns
linelist <- ebola_sim$linelist[,rev(seq_len(ncol(ebola_sim$linelist)))]
contacts <- ebola_sim$contacts[,rev(seq_len(ncol(ebola_sim$contacts)))]
head(linelist)
head(contacts)

## make object
x <- make_epicontacts(linelist, contacts, id = "case_id",
                       to = "case_id", from = "infector")
head(x$linelist)
head(x$contacts)
}
}
\references{
\url{http://foodborne.unl.edu/public/role/epidemiologist/lineLists.html}
}
\author{
Thibaut Jombart (\email{thibautjombart@gmail.com})
}
