% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{pub_fluview_clinical}
\alias{pub_fluview_clinical}
\title{FluView virological data from clinical labs}
\usage{
pub_fluview_clinical(
  regions,
  epiweeks,
  ...,
  issues = NULL,
  lag = NULL,
  fetch_args = fetch_args_list()
)
}
\arguments{
\item{regions}{character. Regions to fetch.}

\item{epiweeks}{\code{\link{timeset}}. Epiweeks to fetch in the form
epirange(startweek,endweek), where startweek and endweek are of the form
YYYYWW (string or numeric).}

\item{...}{not used for values, forces later arguments to bind by name}

\item{issues}{\code{\link{timeset}}. Optionally, the issues to fetch. If not set, the
most recent issue is returned. Mutually exclusive with \code{lag}.}

\item{lag}{integer. Optionally, the lag of the issues to fetch. If not set,
the most recent issue is returned. Mutually exclusive with \code{issues}.}

\item{fetch_args}{\code{\link{fetch_args}}. Additional arguments to pass to \code{fetch()}.}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble}}
}
\description{
API docs: \url{https://cmu-delphi.github.io/delphi-epidata/api/fluview_clinical.html}
}
\examples{
\dontrun{
pub_fluview_clinical(regions = "nat", epiweeks = epirange(201601, 201701))
}
}
\keyword{endpoint}
