% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_predict.R
\name{posterior_predict.epimodel}
\alias{posterior_predict.epimodel}
\title{Draws samples from the posterior predictive distribution of the observations}
\usage{
\method{posterior_predict}{epimodel}(
  object,
  newdata = NULL,
  draws = NULL,
  types = NULL,
  seed = NULL,
  posterior_mean = FALSE,
  ...
)
}
\arguments{
\item{object}{A fitted model object returned by \code{\link{epim}}.
See \code{\link{epimodel-objects}}.}

\item{newdata}{If provided, the original \code{data} used
in \code{object} is overridden. Useful both for counterfactual
and prediction analysis}

\item{draws}{Number of posterior draws to use. Defaults to the number
of parameter draws in the fitted model.}

\item{types}{A character vector specifying the names of the outcome
variables to consider. If unspecified, uses all.}

\item{seed}{An optional seed.}

\item{posterior_mean}{If TRUE, return samples of posterior means rather than
from the posterior predictive.}

\item{...}{Not used.}
}
\value{
A named list of draws from the posterior predictive. Each element
corresponds to a specific outcome.
}
\description{
Generate data from the posterior predictive distribution. This is useful for
assessing the fit of a model. Alternatively this can be used for assessing
counterfactuals or for prediction using the newdata argument.
}
