% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectByIndex.R
\name{selectByIndex}
\alias{selectByIndex}
\title{Select objects by their position.}
\usage{
selectByIndex(index, ...)
}
\arguments{
\item{index}{a numeric value or vector specifying position.}

\item{...}{an arbitrary number of objects to be selected.}
}
\value{
a selected object or a list of selected objects.
}
\description{
This function select objects by their position specified by index.
}
\details{
This function select object by their position specified by index. When index is vector, a list of selected objects is returned. Main use of this function is to select time-specific covariate with \code{getIndex} function.
}
\examples{
id <- 1:10
cov1 <- rnorm(10)
cov2 <- rbinom(10, 4, 0.5)
cov3 <- runif(10)
covset1 <- selectByIndex(c(1,2), id, cov1, cov2, cov3)
cov <- selectByIndex(3, id, cov1, cov2, cov3)
}
\seealso{
\code{\link{getIndex}}, \code{\link{epifit}}
}

