% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{aggregate.multi_epiparameter}
\alias{aggregate.multi_epiparameter}
\title{Aggregate multiple \verb{<epiparameter>} objects into a single \verb{<epiparameter>}
object.}
\usage{
\method{aggregate}{multi_epiparameter}(x, weighting = c("equal", "sample_size", "custom"), ..., weights)
}
\arguments{
\item{x}{A \verb{<multi_epiparameter>} object.}

\item{weighting}{A \code{character} string with the type of weighting to use to
create the mixture distribution. Options are: \code{"equal"} for equal weighting
across distributions, \code{"sample_size"} for using the sample size in each
\verb{<epiparameter>} object to weight the distribution (the sample sizes are
normalised), or \code{"custom"} allows a vector of weights to be passed to the
\code{weights} argument for a custom weighting.}

\item{...}{\link{dots} Not used, will warn if extra arguments are passed to
function.}

\item{weights}{A \code{numeric} vector of equal length the number of
\verb{<epiparameter>} objects passed to \code{x}. \code{weights} is only required if
\code{weighting = "custom"}.}
}
\value{
An \verb{<epiparameter>} object
}
\description{
Combine a list of \verb{<epiparameter>} objects into a single \verb{<epiparameter>}
with a mixture distribution [see \code{\link[distributional:dist_mixture]{distributional::dist_mixture()}}].

The aggregated \verb{<epiparameter>} returned from \code{aggregate()} can then be used
with the \code{density()}, \code{cdf()}, \code{quantile()} and \code{generate()} methods for the
combined distributions.
}
\details{
The \code{aggregate()} method requires that all \verb{<epiparameter>} objects are
parameterised with \verb{<distribution>} objects (from the \pkg{distributional}
package). This means that unparameterised (see \code{\link[=is_parameterised]{is_parameterised()}}) or
discretised (see \code{\link[=discretise]{discretise()}}) distributions cannot be aggregated and the
function will error.
}
\examples{
ebola_si <- epiparameter_db(epi_name = "serial interval", disease = "ebola")
aggregate(ebola_si)
}
