% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiparameter-utils.R
\name{.clean_params}
\alias{.clean_params}
\alias{.clean_params_gamma}
\alias{.clean_params_lnorm}
\alias{.clean_params_nbinom}
\alias{.clean_params_geom}
\alias{.clean_params_pois}
\alias{.clean_params_norm}
\alias{.clean_params_exp}
\title{Standardise distribution parameters}
\usage{
.clean_params(prob_distribution, prob_distribution_params)

.clean_params_gamma(prob_dist_params)

.clean_params_lnorm(prob_dist_params)

.clean_params_nbinom(prob_dist_params)

.clean_params_geom(prob_dist_params)

.clean_params_pois(prob_dist_params)

.clean_params_norm(prob_dist_params)

.clean_params_exp(prob_dist_params)
}
\arguments{
\item{prob_distribution}{A \code{character} string specifying the probability
distribution. This should match the \R naming convention of probability
distributions (e.g. lognormal is \code{lnorm}, negative binomial is \code{nbinom}, and
geometric is \code{geom}).}

\item{prob_distribution_params}{A named vector of probability distribution
parameters.}
}
\value{
Named \code{numeric} vector of parameters.
}
\description{
\code{.clean_params()} dispatches to a distribution
specific parameter cleaning function depending on \code{prob_dist}. For example
\code{prob_dist = "gamma"} will call \code{.clean_params_gamma()}.
}
\details{
Calling \code{\link[=is_epiparameter_params]{is_epiparameter_params()}} at the start of
\code{.clean_params()} ensures that if the parameterisation is
incorrect that it will error early and dispatch to the distribution
specific cleaning functions (e.g. \code{.clean_params_gamma()}).
This means that the distribution specific parameter cleaning functions do
not need to check and error for incorrect parameterisation.
}
\keyword{internal}
