% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multidimBias.R
\name{multidimBias}
\alias{multidimBias}
\title{Multidimensional sensitivity analysis for different sources of bias}
\usage{
multidimBias(case, exposed, type = c("exposure", "outcome", "confounder",
  "selection"), se = NULL, sp = NULL, bias_parms = NULL,
  OR.sel = NULL, alpha = 0.05, dec = 4, print = TRUE)
}
\arguments{
\item{case}{Outcome variable. If a variable, this variable is tabulated
against.}

\item{exposed}{Exposure variable.}

\item{type}{Implement analysis for exposure misclassification, outcome
misclassification, unmeasured confounder, or selection bias.}

\item{se}{Numeric vector of sensitivities.}

\item{sp}{Numeric vector of specificities.}

\item{bias_parms}{List of bias parameters. The list is made of 3 vectors of the same
length:
\enumerate{
\item Prevalence of Confounder in Exposure+ population,
\item Prevalence of Confounder in Exposure- population, and
\item Relative risk between Confounder and Outcome.
}}

\item{OR.sel}{Selection odds ratios, for selection bias implementation.}

\item{alpha}{Significance level.}

\item{dec}{Number of decimals in the printout.}

\item{print}{A logical scalar. Should the results be printed?}
}
\value{
A list with elements:
\item{obs.data}{The analyzed 2 x 2 table from the observed data.}
\item{obs.measures}{A table of odds ratios and relative risk with confidence
intervals.}
\item{adj.measures}{Multidimensional corrected relative risk and/or odds ratio
data.}
\item{bias.parms}{Bias parameters.}
}
\description{
Multidimensional sensitivity analysis for different sources of bias
}
\examples{
multidimBias(matrix(c(45, 94, 257, 945),
dimnames = list(c("HIV+", "HIV-"), c("Circ+", "Circ-")),
nrow = 2, byrow = TRUE),
type = "exposure",
se = c(1, 1, 1, .9, .9, .9, .8, .8, .8),
sp = c(1, .9, .8, 1, .9, .8, 1, .9, .8))
multidimBias(matrix(c(45, 94, 257, 945),
dimnames = list(c("HIV+", "HIV-"), c("Circ+", "Circ-")),
nrow = 2, byrow = TRUE),
type = "outcome",
se = c(1, 1, 1, .9, .9, .9, .8, .8, .8),
sp = c(1, .9, .8, 1, .9, .8, 1, .9, .8))
multidimBias(matrix(c(105, 85, 527, 93),
dimnames = list(c("HIV+", "HIV-"), c("Circ+", "Circ-")),
nrow = 2, byrow = TRUE),
type = "confounder",
bias_parms = list(seq(.72, .92, by = .02),
seq(.01, .11, by = .01), seq(.13, 1.13, by = .1)))
multidimBias(matrix(c(136, 107, 297, 165),
dimnames = list(c("Uveal Melanoma+", "Uveal Melanoma-"),
c("Mobile Use+", "Mobile Use -")),
nrow = 2, byrow = TRUE),
type = "selection",
OR.sel = seq(1.5, 6.5, by = .5))
}
\references{
Lash, T.L., Fox, M.P, Fink, A.K., 2009 \emph{Applying Quantitative
Bias Analysis to Epidemiologic Data}, pp.109--116, Springer.
}
