% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probsens.R
\name{probsens}
\alias{probsens}
\title{Probabilistic sensitivity analysis.}
\usage{
probsens(
  case,
  exposed,
  type = c("exposure", "outcome"),
  reps = 1000,
  seca.parms = list(dist = c("constant", "uniform", "triangular", "trapezoidal",
    "logit-logistic", "logit-normal"), parms = NULL),
  seexp.parms = NULL,
  spca.parms = list(dist = c("constant", "uniform", "triangular", "trapezoidal",
    "logit-logistic", "logit-normal"), parms = NULL),
  spexp.parms = NULL,
  corr.se = NULL,
  corr.sp = NULL,
  discard = TRUE,
  alpha = 0.05
)
}
\arguments{
\item{case}{Outcome variable. If a variable, this variable is tabulated against.}

\item{exposed}{Exposure variable.}

\item{type}{Choice of correction for exposure or outcome misclassification.}

\item{reps}{Number of replications to run.}

\item{seca.parms}{List defining:
\enumerate{
\item The sensitivity of exposure classification among those with the outcome (when \code{type = "exposure"}), or
\item The sensitivity of outcome classification among those with the exposure (when \code{type = "outcome"}).
}
The first argument provides the probability distribution function (constant, uniform, triangular, trapezoidal, logit-logistic, or logit-normal) and the second its parameters as a vector. Logit-logistic and logit-normal distributions can be shifted by providing lower and upper bounds. Avoid providing these values if a non-shifted distribution is desired.
\enumerate{
\item Constant: constant value,
\item Uniform: min, max,
\item Triangular: lower limit, upper limit, mode,
\item Trapezoidal: min, lower mode, upper mode, max,
\item Logit-logistic: location, scale, lower bound shift, upper bound shift,
\item Logit-normal: location, scale, lower bound shift, upper bound shift.
}}

\item{seexp.parms}{List defining:
\enumerate{
\item The sensitivity of exposure classification among those without the outcome (when \code{type = "exposure"}), or
\item The sensitivity of outcome classification among those without the exposure (when \code{type = "outcome"}).
}}

\item{spca.parms}{List as above for \code{seca.parms} but for specificity.}

\item{spexp.parms}{List as above for \code{seexp.parms} but for specificity.}

\item{corr.se}{Correlation between case and non-case sensitivities.}

\item{corr.sp}{Correlation between case and non-case specificities.}

\item{discard}{A logical scalar. In case of negative adjusted count, should the draws be discarded? If set to FALSE, negative counts are set to zero.}

\item{alpha}{Significance level.}
}
\value{
A list with elements:
\item{obs.data}{The analyzed 2 x 2 table from the observed data.}
\item{obs.measures}{A table of observed relative risk and odds ratio with confidence intervals.}
\item{adj.measures}{A table of corrected relative risks and odds ratios.}
\item{sim.df}{Data frame of random parameters and computed values.}
\item{reps}{Number of replications.}
}
\description{
Probabilistic sensitivity analysis to correct for exposure misclassification or
outcome misclassification and random error.
Non-differential misclassification is assumed when only the two bias parameters
\code{seca.parms} and \code{spca.parms} are provided. Adding the 2 parameters
\code{seexp.parms} and \code{spexp.parms} (i.e. providing the 4 bias parameters)
evaluates a differential misclassification.
}
\examples{
# The data for this example come from:
# Greenland S., Salvan A., Wegman D.H., Hallock M.F., Smith T.J.
# A case-control study of cancer mortality at a transformer-assembly facility.
# Int Arch Occup Environ Health 1994; 66(1):49-54.
set.seed(123)
# Exposure misclassification, non-differential
probsens(matrix(c(45, 94, 257, 945),
dimnames = list(c("BC+", "BC-"), c("Smoke+", "Smoke-")), nrow = 2, byrow = TRUE),
type = "exposure",
reps = 20000,
seca.parms = list("trapezoidal", c(.75, .85, .95, 1)),
spca.parms = list("trapezoidal", c(.75, .85, .95, 1)))
# Exposure misclassification, differential
probsens(matrix(c(45, 94, 257, 945),
dimnames = list(c("BC+", "BC-"), c("Smoke+", "Smoke-")), nrow = 2, byrow = TRUE),
type = "exposure",
reps = 20000,
seca.parms = list("trapezoidal", c(.75, .85, .95, 1)),
seexp.parms = list("trapezoidal", c(.7, .8, .9, .95)),
spca.parms = list("trapezoidal", c(.75, .85, .95, 1)),
spexp.parms = list("trapezoidal", c(.7, .8, .9, .95)),
corr.se = .8,
corr.sp = .8)
# Disease misclassification
probsens(matrix(c(173, 602, 134, 663),
dimnames = list(c("BC+", "BC-"), c("Smoke+", "Smoke-")), nrow = 2, byrow = TRUE),
type = "outcome",
reps = 20000,
seca.parms = list("uniform", c(.8, 1)),
spca.parms = list("uniform", c(.8, 1)))
}
\references{
Lash, T.L., Fox, M.P, Fink, A.K., 2009 \emph{Applying Quantitative
Bias Analysis to Epidemiologic Data}, pp.117--150, Springer.
}
