% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.mbias.R
\name{plot.mbias}
\alias{plot.mbias}
\title{Plot DAGs before and after conditioning on collider (M bias)}
\usage{
\method{plot}{mbias}(x, type = c("before", "after"), dec = 2, ...)
}
\arguments{
\item{x}{'mbias' object to plot.}

\item{type}{DAG before or after conditioning on M.}

\item{dec}{Number of digits displayed.}

\item{...}{Other unused arguments.}
}
\value{
A DAG for selection bias caused by M bias.
}
\description{
Create two Directed Acyclic Graphs (DAGs), before and after conditioning on the
collider M, for selection bias caused by M bias, using 'ggdag'.
}
\examples{
plot(mbias(or = c(2, 5.4, 2.5, 1.5, 1),
var = c("HIV", "Circumcision", "Muslim", "Low CD4", "Participation")))

}
\seealso{
\code{\link{mbias}}

Other visualization: 
\code{\link{plot.episensr.booted}()},
\code{\link{plot.episensr.probsens}()}
}
\concept{visualization}
