% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelSIR.R
\name{ModelSIR}
\alias{ModelSIR}
\alias{epiworld_sir}
\alias{plot.epiworld_sir}
\title{SIR model}
\usage{
ModelSIR(name, prevalence, transmission_rate, recovery_rate)

\method{plot}{epiworld_sir}(x, main = get_name(x), ...)
}
\arguments{
\item{name}{String. Name of the virus}

\item{prevalence}{Double. Initial proportion of individuals with the virus.}

\item{transmission_rate}{Numeric scalar between 0 and 1. Virus's rate of
infection.}

\item{recovery_rate}{Numeric scalar between 0 and 1. Rate of recovery_rate from virus.}

\item{x}{Object of class SIR.}

\item{main}{Title of the plot}

\item{...}{Additional arguments passed to \link[graphics:plot.default]{graphics::plot}.}
}
\value{
\itemize{
\item The \code{ModelSIR} function returns a model of class \link{epiworld_model}.
}

\itemize{
\item The \code{plot} function returns a plot of the SIR model of class
\link{epiworld_model}.
}
}
\description{
SIR model
}
\details{
The \link{initial_states} function allows the user to set the initial state of the
model. In particular, the user can specify how many of the non-infected
agents have been removed at the beginning of the simulation.
}
\examples{
model_sir <- ModelSIR(name = "COVID-19", prevalence = 0.01, 
                      transmission_rate = 0.9, recovery_rate = 0.1)

# Adding a small world population
agents_smallworld(
  model_sir,
  n = 1000,
  k = 5,
  d = FALSE,
  p = .01
  )
  
# Running and printing
run(model_sir, ndays = 100, seed = 1912)
model_sir

# Plotting
plot(model_sir)
}
\seealso{
epiworld-methods

Other Models: 
\code{\link{ModelDiffNet}()},
\code{\link{ModelSEIRCONN}()},
\code{\link{ModelSEIRDCONN}()},
\code{\link{ModelSEIRD}()},
\code{\link{ModelSEIR}()},
\code{\link{ModelSIRCONN}()},
\code{\link{ModelSIRDCONN}()},
\code{\link{ModelSIRD}()},
\code{\link{ModelSIRLogit}()},
\code{\link{ModelSISD}()},
\code{\link{ModelSIS}()},
\code{\link{ModelSURV}()},
\code{\link{epiworld-data}}
}
\concept{Models}
