% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install_eplus}
\alias{install_eplus}
\alias{download_eplus}
\title{Download and Install EnergyPlus}
\usage{
install_eplus(ver = "latest", force = FALSE)

download_eplus(ver = "latest", dir)
}
\arguments{
\item{ver}{The EnergyPlus version number, e.g., \code{8.7}. The special value
\code{"latest"}, which is the default, means the latest version.}

\item{force}{Whether to install EnergyPlus even if it has already been
installed.}

\item{dir}{Where to save EnergyPlus installer file. For \code{install_eplus()},
the installer will be saved into \code{\link[=tempdir]{tempdir()}}}
}
\value{
An invisible integer \code{0} if succeed. Moreover, some attributes will
also be returned:
\itemize{
\item For \code{install_eplus()}:
\itemize{
\item \code{path}: the EnergyPlus installation path
\item \code{installer}: the path of downloaded EnergyPlus installer file
}
\item For \code{download_eplus()}:
\itemize{
\item \code{file}: the path of downloaded EnergyPlus installer file
}
}
}
\description{
Download specified version of EnergyPlus for your platform from GitHub and
install it.
}
\details{
\code{download_eplus()} downloads specified version of EnergyPlus from
\href{https://github.com/NREL/EnergyPlus}{EnergyPlus GitHub Repository}.

\code{install_eplus()} will try to install EnergyPlus into the default location,
e.g.  \code{C:\\EnergyPlusVX-Y-0} on Windows, \code{/usr/local/EnergyPlus-X-Y-0} on
Linux, and \code{/Applications/EnergyPlus-X-Y-0} on macOS.

Note that the installation process requires administrative privileges
during the installation and you have to run R with administrator (or with
sudo if you are on Linux) to make it work if you are not in interactive mode.
}
\examples{
\dontrun{

# for the latest version of EnergyPlus
download_eplus("latest", dir = tempdir())
install_eplus("latest")

# for a specific version of EnergyPlus
download_eplus(8.8, dir = tempdir())
install_eplus(8.8)
}
}
\author{
Hongyuan Jia
}
