% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param.R
\docType{class}
\name{ParametricJob}
\alias{ParametricJob}
\title{Create and Run Parametric Analysis, and Collect Results}
\description{
\code{ParametricJob} class provides a prototype of conducting parametric analysis
of EnergyPlus simulations.
}
\details{
Basically, it is a collection of multiple \code{EplusJob} objects. However, the
model is first parsed and the \link{Idf} object is stored internally, instead of
storing only the path of Idf like in \link{EplusJob} class. Also, an object in
\code{Output:SQLite} with \code{Option Type} value of \code{SimpleAndTabular} will be
automatically created if it does not exists, like \link{Idf} class does.
}
\section{Usage}{
\preformatted{param <- param_job(idf, epw)
param$seed()
param$weater()
param$apply_measure(measure, ..., .names = NULL, .mix = FALSE)
param$run(dir = NULL, wait = TRUE, force = FALSE, copy_external = FALSE)
param$kill()
param$status()
param$errors(info = FALSE)
param$output_dir(which = NULL)
param$locate_output(which = NULL, suffix = ".err", strict = TRUE)
param$report_data_dict(which = NULL)
param$report_data(which = NULL, key_value = NULL, name = NULL, year = NULL, tz = "UTC", case = "auto", all = FALSE,
                  period = NULL, month = NULL, day = NULL, hour = NULL, minute = NULL,
                  interval = NULL, simulation_days = NULL, day_type = NULL, environment_name = NULL)
param$tabular_data(which, report_name = NULL, report_for = NULL, table_name = NULL, column_name = NULL, row_name = NULL)
param$print()
}
}

\section{Create}{
\preformatted{param <- param_job(idf, epw)
}

\strong{Arguments}
\itemize{
\item \code{idf}: Path to EnergyPlus IDF file or an \code{Idf} object.
\item \code{epw}: Path to EnergyPlus EPW file or an \code{Epw} object.
}
}

\section{Get Seed Model and Weather}{
\preformatted{param$seed()
param$weather()
}

\code{$seed()} returns the input \link{Idf} object.

\code{$weather()} returns the input \link{Epw} object.
}

\section{Apply Design Alternatives}{
\preformatted{param$apply_measure(measure, ..., .names = NULL)
}

\code{$apply_measure()} allows to apply a measure to an \link{Idf} and creates
parametric models for analysis. Basically, a measure is just a function that
takes an \link{Idf} object and other arguments as input, and returns a modified
\link{Idf} object as output. Use \code{...} to supply different arguments to that
measure. Under the hook, \code{\link[base:mapply]{base::mapply()}} is used to create multiple \link{Idf}s
according to the input values.

\strong{Arguments}
\itemize{
\item \code{measure}: A function that takes an \code{Idf} and other arguments as input and
returns an \code{Idf} object as output.
\item \code{...}: Other arguments passed to that \code{measure}.
\item \code{.names}: A character vector of the names of parametric \code{Idf}s. If \code{NULL},
the new \code{Idf}s will be named in format \code{measure_name + number}.
}
}

\section{Run and Collect Results}{
\preformatted{param$run(dir = NULL, wait = TRUE, force = FALSE, copy_external = FALSE)
param$kill()
param$status()
param$errors(info = FALSE)
param$output_dir(which = NULL)
param$locate_output(which = NULL, suffix = ".err", strict = TRUE)
param$report_data_dict(which = NULL)
param$report_data(which = NULL, key_value = NULL, name = NULL, year = NULL, tz = "UTC", case = "auto", all = FALSE,
                  period = NULL, month = NULL, day = NULL, hour = NULL, minute = NULL,
                  interval = NULL, simulation_days = NULL, day_type = NULL, environment_name = NULL)
param$tabular_data(which, report_name = NULL, report_for = NULL, table_name = NULL, column_name = NULL, row_name = NULL)
}

All those functions have the same meaning as in \link{EplusJob} class, except
that they only return the results of specified simulations. Most arguments
have the same meanings as in \link{EplusJob} class.

\code{$run()} runs all parametric simulations in parallel. The number of parallel
EnergyPlus process can be controlled by \code{eplusr_option("num_parallel")}. If
\code{wait} is FALSE, then the job will be run in the background. You can get
updated job status by just printing the \code{ParametricJob} object.

\code{$kill()} kills all background EnergyPlus processes that are current running
if possible. It only works when simulations run in non-waiting mode.

\code{$status()} returns a named list of values indicates the status of the job:
\itemize{
\item \code{run_before}: \code{TRUE} if the job has been run before. \code{FALSE} otherwise.
\item \code{alive}: \code{TRUE} if the job is still running in the background. \code{FALSE}
otherwise.
\item \code{terminated}: \code{TRUE} if the job was terminated during last
simulation. \code{FALSE} otherwise. \code{NA} if the job has not been run yet.
\item \code{successful}: \code{TRUE} if last simulation ended successfully. \code{FALSE}
otherwise. \code{NA} if the job has not been run yet.
\item \code{changed_after}: \code{TRUE} if the \emph{seed model} has been modified since last
simulation. \code{FALSE} otherwise.
}

$errors() returns an \link[=read_err]{ErrFile} object which contains all contents
of the simulation error file (\code{.err}). If \code{info} is \code{FALSE}, only warnings
and errors are printed.

\code{$output_dir()} returns the output directory of specified simulations.

\code{$locate_output()} returns the path of a single output file of specified
simulations.

\code{$report_data_dict()} returns a \link[data.table:data.table]{data.table} which
contains all information about report data for specified simulations. For
details on the meaning of each columns, please see "2.20.2.1
ReportDataDictionary Table" in EnergyPlus "Output Details and Examples"
documentation.

\code{$report_data()} extracts the report data in a
\link[data.table:data.table]{data.table} using key values, variable names and other arguments.

\code{$tabular_data()} extracts tabular data in a
\link[data.table:data.table]{data.table}.

For convenience, input character arguments matching in \code{$report_data()} and
\code{$tabular_data()} are \strong{case-insensitive}.

For \code{$report_data_dict()}, \code{$report_data()} and \code{$tabular_data()}, the
returned data.table has a \code{case} column in the returned
\link[data.table:data.table]{data.table} that indicates the names of parametric
models. For detailed documentation of those methods, please see \link{EplusSql}.

\strong{Arguments}
\itemize{
\item \code{which}: An integer vector of the indexes or a character vector or names of
parametric simulations. If \code{NULL}, results of all parametric simulations
are returned. Default: \code{NULL}.
\item \code{dir}: The parent output directory for specified simulations. Outputs of
each simulation are placed in a separate folder under the parent directory.
\item \code{wait}: If \code{TRUE}, R will hang on and wait all EnergyPlus simulations
finish. If \code{FALSE}, all EnergyPlus simulations are run in the background.
Default: \code{TRUE}.
\item \code{force}: Only applicable when the last simulation runs with \code{wait} equals
to \code{FALSE} and is still running. If \code{TRUE}, current running job is
forced to stop and a new one will start. Default: \code{FALSE}.
\item \code{copy_external}: If \code{TRUE}, the external files that every \code{Idf} object
depends on will also be copied into the simulation output directory. The
values of file paths in the Idf will be changed automatically. Currently,
only \code{Schedule:File} class is supported.  This ensures that the output
directory will have all files needed for the model to run. Default is
\code{FALSE}.
\item \code{suffix}: A string that indicates the file extension of simulation output.
Default: \code{".err"}.
\item \code{strict}: If \code{TRUE}, it checks if the simulation was terminated, is
still running or the file does not exist. Default: \code{TRUE}.
\item \code{info}: If \code{FALSE},only warnings and errors are printed. Default: \code{FALSE}.
\item \code{key_value}: A character vector to identify key values of the data. If
\code{NULL}, all keys of that variable will be returned. \code{key_value} can also be
data.frame that contains \code{key_value} and \code{name} columns. In this case,
\code{name} argument in \code{$report_data()} is ignored. All available \code{key_value}
for current simulation output can be obtained using \code{$report_data_dict()}.
Default: \code{NULL}.
\item \code{name}: A character vector to identify names of the data. If
\code{NULL}, all names of that variable will be returned. If \code{key_value} is a
data.frame, \code{name} is ignored. All available \code{name} for current simulation
output can be obtained using \code{$report_data_dict()}.  Default: \code{NULL}.
\item \code{year}: Year of the date time in column \code{datetime}. If \code{NULL}, it
will calculate a year value that meets the start day of week restriction
for each environment. Default: \code{NULL}.
\item \code{tz}: Time zone of date time in column \code{datetime}. Default: \code{"UTC"}.
\item \code{case}: If not \code{NULL}, a character column will be added indicates the case
of this simulation. If \code{"auto"}, the name of the IDF file without extension
is used.
\item \code{all}: If \code{TRUE}, extra columns are also included in the returned
\link[data.table:data.table]{data.table}.
\item \code{period}: A Date or POSIXt vector used to specify which time period to
return. The year value does not matter and only month, day, hour and
minute value will be used when subsetting. If \code{NULL}, all time period of
data is returned. Default: \code{NULL}.
\item \code{month}, \code{day}, \code{hour}, \code{minute}: Each is an integer vector for month, day,
hour, minute subsetting of \code{datetime} column when querying on the SQL
database. If \code{NULL}, no subsetting is performed on those components. All
possible \code{month}, \code{day}, \code{hour} and \code{minute} can be obtained using
\code{$read_table("Time")}.  Default: \code{NULL}.
\item \code{interval}: An integer vector used to specify which interval length of
report to extract. If \code{NULL}, all interval will be used. Default: \code{NULL}.
\item \code{simulation_days}: An integer vector to specify which simulation day data
to extract. Note that this number resets after warmup and at the beginning
of an environment period. All possible \code{simulation_days} can be obtained
using \code{$read_table("Time")}. If \code{NULL}, all simulation days will be used.
Default: \code{NULL}.
\item \code{day_type}: A character vector to specify which day type of data to
extract. All possible day types are: \code{Sunday}, \code{Monday}, \code{Tuesday},
\code{Wednesday}, \code{Thursday}, \code{Friday}, \code{Saturday}, \code{Holiday},
\code{SummerDesignDay}, \code{WinterDesignDay}, \code{CustomDay1}, and \code{CustomDay2}. All
possible values for current simulation output can be obtained using
\code{$read_table("Time")}.
\item \code{environment_name}: A character vector to specify which environment data to
extract. All possible \code{environment_name} for current simulation output can
be obtained using \code{$read_table("EnvironmentPeriods"). }If \code{NULL}, all
environment data are returned. Default: \code{NULL}.
\item \code{report_name}, \code{report_for}, \code{table_name}, \code{column_name}, \code{row_name}:
Each is a character vector for subsetting when querying the SQL database.
For the meaning of each argument, please see the description above.
}
}

\section{Printing}{
\preformatted{param$print()
print(param)
}

\code{$print()} shows the core information of this \code{ParametricJob}, including the
path of seed model and weather, the version and path of EnergyPlus used to
run simulations, the measure that has been applied and parametric models
generated, and also the simulation job status.

\code{$print()} is quite useful to get the simulation status, especially when
\code{wait} is \code{FALSE} in \code{$run()}. The job status will be updated and printed
whenever \code{$print()} is called.
}

\examples{
if (is_avail_eplus(8.8)) {
    idf_name <- "1ZoneUncontrolled.idf"
    epw_name <-  "USA_CA_San.Francisco.Intl.AP.724940_TMY3.epw"

    idf_path <- file.path(eplus_config(8.8)$dir, "ExampleFiles", idf_name)
    epw_path <- file.path(eplus_config(8.8)$dir, "WeatherData", epw_name)

    # create from local files
    param_job(idf_path, epw_path)

    # create from an Idf and an Epw object
    param_job(read_idf(idf_path), read_epw(epw_path))
}
}
\author{
Hongyuan Jia
}
