% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impl-idf.R
\name{expand_idf_dots_name}
\alias{expand_idf_dots_name}
\title{Parse object ID or name specifications given in list format}
\usage{
expand_idf_dots_name(
  idd_env,
  idf_env,
  ...,
  .keep_name = TRUE,
  .property = NULL
)
}
\arguments{
\item{idd_env}{An environment or list contains IDD tables including class,
field, and reference.}

\item{idf_env}{An environment or list contains IDF tables including object,
value, and reference.}

\item{...}{Lists of object ID or name pair, e.g. \code{c(Name1, Name2)}, \code{c(ID1, ID2)}, \code{NewName = OldName} and \code{NewName = ID}. \code{NewName} is optional.}

\item{.keep_name}{If \code{TRUE}, input new names will be kept in a column named
\code{new_object_name}, otherwise they will be dropped. Default: \code{TRUE}.}

\item{.property}{A character vector of column names in class table to return.
Default: \code{NULL}.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} containing extracted object data.
}
\description{
Parse object ID or name specifications given in list format
}
\keyword{internal}
