% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eplusr.R
\name{eplusr_option}
\alias{eplusr_option}
\title{Get and Set eplusr options}
\usage{
eplusr_option(...)
}
\arguments{
\item{...}{Any options can be defined, using \code{name = value}. All available
options are below. If no options are given, then all values of current
options are returned.}
}
\description{
Get and set eplusr options which affect the way in which eplusr computes and
displays its results.
}
\details{
\itemize{
\item \code{num_digits}: Integer indicating the number of decimal places for numeric
fields. Default: \code{8L}
\item \code{view_in_ip}: Whether models should be presented in IP units.  Default:
\code{FALSE}
\item \code{validate_level}: The strictness level of validation during field value
modification and model error checking. Possible value: \code{"none"},
\code{"draft"} and \code{"final"}. Default: \code{"final"}. Detailed description:
\itemize{
\item For \code{"none"}, none validation will be done;
\item For \code{"draft"}, checking of invalid autosize, autocalculate, numeric,
integer, and choice field values will be done;
\item For \code{"final"}, besides above, checking of missing required objects,
duplicated unique objects, object name conflicts, missing required fields
and invalid field value reference will also be done.
}
\item \code{verbose_info}: Whether to show information messages. Default: \code{TRUE}.
\item \code{save_format}: The format to use when saving Idf objects to \code{.idf} files.
Possible values: \code{"asis"}, \code{"sorted"}, \code{"new_top"} and \code{"new_bottom"}.
The later three have the same effect as \code{Save Options} settings
\code{"Sorted"}, \code{"Original with New at Top"} and \code{"Original with New at Bottom"} in IDF Editor, respectively. For \code{"asis"}, the saving format
will be set according to the header of IDF file. If no header found,
\code{"sorted"} is used. "Default: \code{"asis"}.
\item \code{num_parallel}: Maximum number of parallel simulations to run. Default:
\code{parallel::detectCores()}.
}
}
