% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epw.R
\name{read_epw}
\alias{read_epw}
\title{Read and Parse EnergyPlus Weather File (EPW)}
\usage{
read_epw(path)
}
\arguments{
\item{path}{A path of an EnergyPlus \code{EPW} file.}
}
\value{
An \code{Epw} object.
}
\description{
\code{read_epw()} parses an EPW file and returns an \code{Epw} object. The parsing
process is extreme inspired by \href{https://openstudio-sdk-documentation.s3.amazonaws.com/cpp/OpenStudio-2.5.1-doc/utilities/html/classopenstudio_1_1_epw_file.html}{OpenStudio utilities library}
with some simplifications. For more details on \code{Epw}, please see \link{Epw} class.
}
\examples{
# read an EPW file from EnergyPlus v8.8 installation folder
if (is_avail_eplus(8.8)) {
    path_epw <- file.path(
        eplus_config(8.8)$dir,
        "WeatherData",
        "USA_CA_San.Francisco.Intl.AP.724940_TMY3.epw"
   )
   epw <- read_epw(path_epw)
}

\dontrun{
# read an EPW file from EnergyPlus website
path_base <- "https://energyplus.net/weather-download"
path_region <- "north_and_central_america_wmo_region_4/USA/CA"
path_file <- "USA_CA_San.Francisco.Intl.AP.724940_TMY3/USA_CA_San.Francisco.Intl.AP.724940_TMY3.epw"
path_epw <- file.path(path_base, path_region, path_file)
epw <- read_epw(path_epw)
}
}
\seealso{
\link{Epw} class
}
\author{
Hongyuan Jia
}
