% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{createBaseTable}
\alias{createBaseTable}
\title{Main function to call everything and produce the results}
\usage{
createBaseTable(coocepso, coocesso, coocepi)
}
\arguments{
\item{coocepso}{list of drug names sorted by frequency co-occuring with EpSO}

\item{coocesso}{list of drug names sorted by frequency co-occuring with ESSO}

\item{coocepi}{list of drug names sorted by frequency co-occuring with EPILONT}
}
\value{
result table containin the aggregated list of drug terms and their associations
}
\description{
Main function to call everything and produce the results
}
\examples{
utils::data(rawDrugNamesCoOcEpSO, package="epos")
utils::data(rawDrugNamesCoOcESSO, package="epos")
utils::data(rawDrugNamesCoOcEPILONT, package="epos")
createBaseTable(coocepso = rawDrugNamesCoOcEpSO[1:150],
  coocesso=rawDrugNamesCoOcESSO[1:150],
  coocepi=rawDrugNamesCoOcEPILONT[1:150])
}
