# Build-in string constants
LETTERS; letters; month.abb; month.name; state.abb; state.name
three <- state.name[1:3]; three

# Creating a string
animal <- c("dog", "chick", "pig")
var.a <- paste("v", 1:5, c("x", "y", "z"), sep = ".")
var.b <- paste("v", 1:5, c("x", "y", "z"), sep = ".", collapse = "|")
var.a; var.b

# Displaying or printing a string
three.nq <- noquote(three)
three.nq; class(three.nq); mode(three.nq)
cat("Need a matrix to this function.")    # Where is the prompt sign?
cat("Need a matrix to this function.\n")  # A new line is created
cat("Output A:\t", "generated by \'glm\'", "\n") 
cat("The function works with data frame.", "But it is best", 
  "to have matrix objects.", fill = 40)
cat("This will be saved on your local drive.\n", file = "c:/test.txt")
library(erer); print.maTrend  # example: cat with a print method
three.da <- data.frame(three, stringsAsFactors = FALSE)
three.db <- data.frame(I(three))
str(three.db); three.db 

# Character number and case
length(month.name); nchar(month.name)
tu1 <- toupper(three); tu2 <- casefold(three, upper = TRUE)
tw1 <- tolower(three); tw2 <- casefold(three, upper = FALSE)
num <- toupper("abc45Y") # numbers are not affected
three.ch <- chartr(old = "Az", new = "aZ", x = three)
tu1; tw1; num; three.ch

# Extracting and replacing parts from a string
three.abb <- three.abb2 <- tolower(substr(three, start = 1, stop = 4))
substring(three.abb2, first = 1, last = 4) <- c("sout", "nort", "west")
one <- strsplit("Alabama", split = "")  # individual letters
two <- strsplit("Alabama", split = "a") # split by "a" 
one; two