% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitWtErgmTerm.R
\name{CMB-ergmTerm}
\alias{CMB-ergmTerm}
\alias{InitWtErgmTerm.CMB}
\title{Conway-Maxwell-Binomial Distribution}
\usage{
# valued: CMB(trials, coupled = TRUE)
}
\arguments{
\item{trails}{model parameter}

\item{coupled}{logical}
}
\description{
If \code{couple==TRUE} , this
term adds one statistic to the model, of the form
\eqn{\sum_{i,j}\log(y_{i,j}!) + \log(t-y_{i,j}!)} . This turns a Binomial- or a
discrete-uniform-reference ERGM into a Conway-Maxwell-Binomial-reference
ERGM, allowing it to represent a broad range of disperson
values. In particular, combined with a Binomial-reference ERGM, a
negative coefficient on this term induces underdispersion and a
positive coefficient induces overdispersion.

If \code{coupled==FALSE} the two summands above are added as their own
statistic (each with its own free parameter).
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "CMB", "subsection")}
}
\concept{directed}
\concept{nonnegative}
\concept{undirected}
