% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degreedist.R
\name{mixingmatrix.egodata}
\alias{mixingmatrix.egodata}
\title{Summarizing the mixing among groups in an egocentric dataset}
\usage{
mixingmatrix.egodata(object, attrname, rowprob = FALSE, ...)
}
\arguments{
\item{object}{A \code{\link{egodata}} object.}

\item{attrname}{A character vector containing the name of the network
attribute whose mixing matrix is wanted.}

\item{rowprob}{Whether the counts should be normalized by row sums. That is,
whether they should be proportions conditional on the ego's group.}

\item{...}{Additional arguments, currently unused.}
}
\value{
A matrix with a row and a column for each level of \code{attrname}.

Note that, unlike \code{\link[network]{mixingmatrix}}, what is counted are
\emph{nominations}, not ties. This means that under an egocentric census,
the diagonal of \code{mixingmatrix.egodata} will be twice that returned by
\code{\link[network]{mixingmatrix}} for the original undirected network.
}
\description{
A \code{\link[network]{mixingmatrix}} "method" for
\code{\link{egodata}} objects, to return counts of how often a ego
of each group nominates an alter of each group.
}
\note{
As of the \code{ergm.ego} 0.4 release, \code{network}
package's \code{\link[=mixingmatrix]{mixingmatrix()}} is not a generic, so this function is
not a method. A future release of \code{network} will make it so.
}
\examples{

data(faux.mesa.high)
fmh.ego <- as.egodata(faux.mesa.high)

(mm <- mixingmatrix(faux.mesa.high,"Grade"))
(mm.ego <- mixingmatrix.egodata(fmh.ego,"Grade"))

stopifnot(isTRUE(all.equal({tmp<-unclass(mm$matrix); diag(tmp) <- diag(tmp)*2;
tmp}, mm.ego, check.attributes=FALSE)))

}
\seealso{
\code{\link[network]{mixingmatrix}}, \code{\link[ergm]{nodemix}},
\code{\link[ergm.ego]{summary}} method for egocentric data
}
