% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.ergm.ego.R
\name{control.ergm.ego}
\alias{control.ergm.ego}
\title{Control parameters for \code{\link{ergm.ego}}.}
\usage{
control.ergm.ego(
  ppopsize = c("auto", "samp", "pop"),
  ppopsize.mul = 1,
  ppop.wt = c("round", "sample"),
  stats.wt = c("data", "ppop"),
  stats.est = c("survey", "asymptotic", "bootstrap", "jackknife", "naive"),
  boot.R = 10000,
  ignore.max.alters = TRUE,
  ergm = control.ergm(),
  ...
)
}
\arguments{
\item{ppopsize, ppopsize.mul}{Parameters to determine the size
\eqn{|N'|} of the pseudopopulation network. \code{ppopsize} can be
\describe{

\item{"auto"}{If the \code{popsize} (\eqn{|N|}) argument is
specified and is different from 1, as if \code{"pop"}; otherwise,
as \code{"samp"}.}

\item{"samp"}{set \eqn{|N'|} based on the sample size:
\eqn{|N'|=|S| \times \code{popsize.mul}}}

\item{"pop"}{set \eqn{|N'|} based on the population size:
\eqn{|N'|=|N| \times \code{popsize.mul}}}

\item{a number}{set \eqn{|N'|} directly (\code{popsize.mul}
ignored)}

\item{a \code{\link{network}} object}{use the specified network as the
pseudo-population network directly; use at your own risk}

\item{a data frame}{use the specified data frame as the
pseudo-population; use at your own risk}}

The default is to use the same pseudopopulation size as the sample size,
but, particularly if there are sampling weights in the data, it should be
bigger.

Note that depending on \code{ppop.wt}, this may only be an approximate
target specification, with the actual constructed pseudopopulation network
being slightly bigger or smaller.}

\item{ppop.wt}{Because each ego must be represented in the pseuodopopulation
network an integral number of times, if the sample is weighted (or the
target \eqn{|N'|} calculated from \code{ppopsize} and \code{ppopsize.mul} is
not a multiple of the sample size), it may not be possible, for a finite
\eqn{|N'|} to represent each ego exactly according to its relative weight,
and \code{ppop.wt} controls how the fractional egos are allocated:
\describe{ \item{"round"}{(default) Rather than treating \code{ppopsize} as
a hard setting, calculate \eqn{|N'| w_i / w_\cdot} for each ego \eqn{i} and
round it to the nearest integer. Then, the \eqn{|N'|} actually used will be
the sum of these rounded freqencies.}
\item{"sample"}{Resample in proportion to \eqn{w_i}.} }}

\item{stats.wt}{Weight assigned to each ego's contribution to the ERGM's
sufficient statistic: \describe{ \item{"data"}{(default) Use weights
\eqn{|N'| w_i / w_\cdot} for each ego \eqn{i} as in the data.} \item{"ppop"}{Use weights ultimately used in the
pseudopopulation network.} }}

\item{stats.est, boot.R}{Method to be used to estimate the ERGM's sufficient
statistics and their variance: \describe{
\item{"survey"}{Variance estimator returned by \code{\link[survey:surveysummary]{survey::svymean()}}, appropriate to the design of the dataset.}
\item{"asymptotic"}{Delta method, as derived by Krivitsky and
Morris (2017), assuming the ego weights are sampled alongside the
egos.}\item{ (default)}{Delta method, as derived by Krivitsky and Morris
(2017), assuming the ego weights are sampled alongside the egos.}
\item{"bootstrap"}{Nonparametric bootstrap with bias correction,
resampling egos, using \code{R} replications.}
\item{"jackknife"}{Jackknife with bias correction.}
\item{"naive"}{"Naive" estimator, assuming that weights are
fixed.} }}

\item{ignore.max.alters}{if \code{TRUE}, ignores any constraints on the
number of nominations. Used to be \code{FALSE}, now \code{TRUE} in light of
the findings of Krivitsky et. al (2020).}

\item{ergm}{Control parameters for the \code{\link[ergm]{ergm}()} call
to fit the model, constructed by \code{\link[ergm]{control.ergm}()}.}

\item{\dots}{Not used at this time.}
}
\value{
A list with arguments as components.
}
\description{
Constructs and checks the list of control parameters for estimation by
\code{\link{ergm.ego}}.
}
\references{
Pavel N. Krivitsky and Martina Morris (2017). "Inference for social network models from egocentrically sampled data, with application to understanding persistent racial disparities in HIV prevalence in the US." \emph{Annals of Applied Statistics}, 11(1): 427–455. \doi{10.1214/16-AOAS1010}

Pavel N. Krivitsky, Martina Morris, and Michał Bojanowski (2019). "Inference for Exponential-Family Random Graph Models from Egocentrically-Sampled Data with Alter–Alter Relations." NIASRA Working Paper 08-19. \url{https://www.uow.edu.au/niasra/publications/}

Pavel N. Krivitsky, Michał Bojanowski, and Martina Morris (2020). "Impact of survey design on estimation of exponential-family random graph models from egocentrically-sampled data." \emph{Social Networks}, to appear. \doi{10.1016/j.socnet.2020.10.001}

Pavel N. Krivitsky, Mark S. Handcock, and Martina Morris (2011). "Adjusting for
Network Size and Composition Effects in Exponential-Family Random Graph
Models." \emph{Statistical Methodology}, 8(4): 319–339. \doi{10.1016/j.stamet.2011.01.005}
}
\seealso{
\code{\link[ergm]{control.ergm}()}
}
\author{
Pavel N. Krivitsky
}
\keyword{models}
