% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gofN.R
\name{gofN}
\alias{gofN}
\alias{[.gofN}
\alias{plot.gofN}
\alias{summary.gofN}
\title{Linear model diagnostics for multinetwork linear models}
\usage{
gofN(
  object,
  GOF = NULL,
  subset = TRUE,
  control = control.gofN.ergm(),
  save_stats = FALSE,
  ...
)

\method{[}{gofN}(x, i, j, ..., drop = FALSE)

\method{plot}{gofN}(
  x,
  against = NULL,
  which = 1:2,
  col = 1,
  pch = 1,
  cex = 1,
  bg = 0,
  ...,
  ask = length(which) > 1 && dev.interactive(TRUE),
  id.n = 3,
  main = "{type} for {sQuote(name)}",
  xlab = NULL,
  ylim = NULL,
  cex.id = 0.75
)

\method{summary}{gofN}(object, by = NULL, ...)
}
\arguments{
\item{object}{an \code{\link{ergm}} object.}

\item{GOF}{a one-sided \code{\link{ergm}} formula specifying network
statistics whose goodness of fit to test, or \code{\link{NULL}}; if \code{NULL},
uses the original model.}

\item{subset}{argument for the \code{\link[=N-ergmTerm]{N}} term.}

\item{control}{See \code{\link[=control.gofN.ergm]{control.gofN.ergm()}}.}

\item{save_stats}{If \code{TRUE}, save the simulated network statistics;
defaults to \code{FALSE} to save memory and disk space.}

\item{\dots}{additional arguments to functions (\code{\link[=simulate.ergm]{simulate.ergm()}}
and \code{\link[=summary.ergm_model]{summary.ergm_model()}} for the constructor, \code{\link[=plot]{plot()}},
\code{\link[=qqnorm]{qqnorm()}}, and \code{\link[=qqline]{qqline()}} for the plotting method).}

\item{x}{a \code{\link{gofN}} object.}

\item{i}{for the indexing operator, index of statistics to be kept in the subset.}

\item{j}{for the indexing operator, index of networks to be kept in the subset.}

\item{drop}{whether the indexing operator should drop attributes and return simply a list.}

\item{against}{vector of values, network attribute, or a formula whose RHS gives an expression in terms of network attributes to plot against; if \code{NULL} (default), plots against fitted values. The formula may also contain a \code{.fitted} variable which will be substituted with the fitted values. Factor values are visualised using boxplots.}

\item{which}{which to plot (\code{1} for residuals plot, \code{2} for \eqn{\sqrt{|R_i|}}{sqrt(|R_i|)} scale plot, and \code{3} for normal quantile-quantile plot).}

\item{col, pch, cex, bg}{vector of values (wrapped in \code{\link[=I]{I()}}), network attribute, or a formula whose RHS gives an expression in terms of network attributes to plot against.}

\item{ask}{whether the user should be prompted between the plots.}

\item{id.n}{Number of extreme points to label explicitly.}

\item{main}{A template for the plots' titles; these use \code{\link[=glue]{glue()}}'s templating, with \code{{type}} replaced with the type of plot and \code{{name}} replaced with the statistic.}

\item{xlab}{Horizontal axis label; defaults to a character representation of \code{against}.}

\item{ylim}{Vertical range for the plots, interpreted as in \code{\link[graphics:plot.default]{graphics::plot()}}; can be specified as a list with 3 elements, giving the range for the corresponding plot according to the plot numbers for the \verb{which=} argument, and can be used to ensure that, e.g., diagnostic plots for different models are on the same scale.}

\item{cex.id}{Scaling factor for characters used to label extreme points; see \code{\link[=plot.lm]{plot.lm()}}.}

\item{by}{a numeric or character vector, or a formula whose RHS gives an expression in terms of network attributes, used as a grouping variable for summarizing the values.}
}
\value{
An object of class \code{gofN}: a named list containing a list
for every statistic in the specified \code{GOF} formula with the
following elements vectors of length equal to the number of
subnetworks:

\item{observed}{For completely observed networks, their value of
the statistic. For partially observed networks, the expected value
of their imputations under the model.}

\item{fitted}{Expected value of the statistic under the model.}

\item{var}{Variance of the statistic under the model.}

\item{var.obs}{Conditional variance under imputation statistic.}

\item{pearson}{The Pearson residual computed from the above.}

\item{stats,stats.obs}{If \code{save_stats} control parameter is \code{TRUE}, the simulated statistics.}

In addition, the following \code{\link{attr}}-style attributes are included:

\item{nw}{The observed multinetwork object.}

\item{subset}{A logical vector giving the subset of networks that were used.}

\item{control}{Control parameters passed.}
}
\description{
\code{\link[=gofN]{gofN()}} performs a simulation to obtain Pearson residuals for the
multivariate linear model for ERGM parameters, which can then be
used for a variety of diagnostics and diagnostic plots developed by
\insertCite{KrCo22t;textual}{ergm.multi}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{[}: Extract a subset of statistics for which goodness-of-fit had been computed.

\item \code{plot(gofN)}: A plotting method, making residual and scale-location plots.

\item \code{summary(gofN)}: A simple summary function.

}}
\examples{
data(samplk)
monks <- Networks(samplk1, samplk2, samplk3,samplk1, samplk2, samplk3,samplk1, samplk2, samplk3)
fit <- ergm(monks~N(~edges+nodematch("group")))
fit.gof <- gofN(fit) # GOF = original model
summary(fit.gof)
plot(fit.gof)
fit.gof <- gofN(fit, GOF=~triangles)
summary(fit.gof)
plot(fit.gof)

\donttest{
samplk1[1,]<-NA
samplk2[,2]<-NA
monks <- Networks(samplk1, samplk2, samplk3,samplk1, samplk2, samplk3,samplk1, samplk2, samplk3)
fit <- ergm(monks~N(~edges+nodematch("group")))
fit.gof <- gofN(fit) # GOF = original model
summary(fit.gof)
plot(fit.gof)
fit.gof <- gofN(fit, GOF=~triangles)
summary(fit.gof)
plot(fit.gof)
plot(fit.gof, against=~log(.fitted)) # Plot against transformed fitted values.
}

# Default is good enough in this case, but sometimes, we might want to set it higher. E.g.,
\dontrun{
fit.gof <- gofN(fit, GOF=~edges, control=control.gofN.ergm(nsim=400))
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[ergm:gof]{ergm::gof()}} for single-network goodness-of-fit simulations in \CRANpkg{ergm}

\code{\link[=plot.lm]{plot.lm()}}, \code{\link[graphics:plot.default]{graphics::plot()}} for regression diagnostic plots and their parameters
}
