% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm-package.R
\docType{package}
\name{ergmReference}
\alias{ergmReference}
\alias{ergm-references}
\alias{references-ergm}
\alias{ergm.references}
\alias{references.ergm}
\title{Reference Measures for Exponential-Family Random Graph Models}
\description{
This page describes how to specify the reference measures (baseline distributions)
(the set of possible networks \eqn{Y} and the baseline weights \eqn{h(y)} to functions in the \code{\link[=ergm-package]{ergm}}
package. It also provides an indexed list of the references visible to the \CRANpkg{ergm}'s API.
}
\section{Specifying reference measures}{

\ERGMspec

The reference measure \eqn{(Y,h(y))} is specified on the right-hand side of a one-sided formula passed
typically as the \code{reference} argument.
}

\section{Reference measures visible to the package}{

\if{latex}{\Sexpr[results=rd,stage=render]{ergm:::.formatIndexLatex(ergm:::.buildTermsDataframe("ergmReference"))}}
\if{text}{\Sexpr[results=rd,stage=render]{ergm:::.formatIndexText(ergm:::.buildTermsDataframe("ergmReference"))}}
\if{html}{\Sexpr[results=rd,stage=render]{ergm:::.formatIndexHtml(ergm:::.buildTermsDataframe("ergmReference"))}}
\subsection{All references}{

\if{latex}{\Sexpr[results=rd,stage=render]{ergm:::.formatMatrixLatex(ergm:::.termMatrix("ergmReference"))}}
\if{text}{\Sexpr[results=rd,stage=render]{ergm:::.formatMatrixText(ergm:::.termMatrix("ergmReference"))}}
\if{html}{\Sexpr[results=rd,stage=render]{ergm:::.formatMatrixHtml(ergm:::.termMatrix("ergmReference"))}}
}

\subsection{References by keywords}{

\if{latex}{\Sexpr[results=rd,stage=render]{ergm:::.formatTocLatex(ergm:::.termToc("ergmReference"))}}
\if{text}{\Sexpr[results=rd,stage=render]{ergm:::.formatTocText(ergm:::.termToc("ergmReference"))}}
\if{html}{\Sexpr[results=rd,stage=render]{ergm:::.formatTocHtml(ergm:::.termToc("ergmReference"))}}
}
}

\references{
\itemize{
\item Hunter DR, Handcock MS, Butts CT, Goodreau SM, Morris M (2008b). \pkg{ergm}:
A Package to Fit, Simulate and Diagnose Exponential-Family Models for
Networks. \emph{Journal of Statistical Software}, 24(3).
\doi{10.18637/jss.v024.i03}
\item Krivitsky PN (2012). Exponential-Family Random Graph Models for Valued
Networks. \emph{Electronic Journal of Statistics}, 2012, 6, 1100-1128.
\doi{10.1214/12-EJS696}
}
}
\seealso{
\code{\link[=ergm-package]{ergm}}, \code{\link{network}}, \code{sna}, \code{\link{summary.ergm}}, \code{\link{print.ergm}}, \verb{\\\%v\\\%}, \verb{\\\%n\\\%}
}
\keyword{models}
