% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm-terms-index.R
\name{search.ergmTerms}
\alias{search.ergmTerms}
\alias{search.ergmConstraints}
\alias{search.ergmReferences}
\alias{search.ergmHints}
\alias{search.ergmProposals}
\title{Search ERGM terms, constraints, references, hints, and proposals}
\usage{
search.ergmTerms(search, net, keywords, name, packages)

search.ergmConstraints(search, keywords, name, packages)

search.ergmReferences(search, keywords, name, packages)

search.ergmHints(search, keywords, name, packages)

search.ergmProposals(search, name, reference, constraints, packages)
}
\arguments{
\item{search}{optional character search term to search for in the text of the
term descriptions. Only matching terms will be returned. Matching is case
insensitive.}

\item{net}{a network object that the term would be applied to, used as
template to determine directedness, bipartite, etc}

\item{keywords}{optional character vector of keyword tags to use to
restrict the results (i.e. 'curved', 'triad-related')}

\item{name}{optional character name of a specific term to return}

\item{packages}{optional character vector indicating the subset of packages in which to search}

\item{reference, constraints}{optional names of references and constraints to narrow down the proposal}
}
\value{
prints out the name and short description of matching terms, and
invisibly returns them as a list.  If \code{name} is specified, prints out
the full definition for the named term.
}
\description{
Searches through the database of \code{\link{ergmTerm}}s,
\code{\link{ergmConstraint}}s, \code{\link{ergmReference}}s, \code{\link{ergmHint}}s, and
\code{\link{ergmProposal}}s and prints out a list of terms and term-alikes
appropriate for the specified network's structural constraints,
optionally restricting by additional keywords and search term
matches.
}
\details{
Uses \code{\link{grep}} internally to match the search terms against the term
description, so \code{search} is currently matched as a single phrase.
Keyword tags will only return a match if all of the specified tags are
included in the term.
}
\examples{
\donttest{
# find all of the terms that mention triangles
search.ergmTerms('triangle')

# two ways to search for bipartite terms:

# search using a bipartite net as a template
myNet<-network.initialize(5,bipartite=3)
search.ergmTerms(net=myNet)

# or request the bipartite keyword
search.ergmTerms(keywords='bipartite')

# search on multiple keywords
search.ergmTerms(keywords=c('bipartite','dyad-independent'))

# print out the content for a specific term
search.ergmTerms(name='b2factor')

# request the bipartite keyword in the ergm package
search.ergmTerms(keywords='bipartite', packages='ergm')
}
\donttest{
# find all of the constraint that mention degrees
search.ergmConstraints('degree')

# search for hints only
search.ergmConstraints(keywords='hint')

# search on multiple keywords
search.ergmConstraints(keywords=c('directed','dyad-independent'))

# print out the content for a specific constraint
search.ergmConstraints(name='b1degrees')

# request the bipartite keyword in the ergm package
search.ergmConstraints(keywords='directed', packages='ergm')
}
\donttest{
# find all discrete references
search.ergmReferences(keywords='discrete')
}
\donttest{
# find all of the hints
search.ergmHints('degree')
}
\donttest{
# find all of the proposals that mention triangles
search.ergmProposals('MH algorithm')

# print out the content for a specific proposals
search.ergmProposals(name='randomtoggle')

# find all proposals with required or optional constraints
search.ergmProposals(constraints='.dyads')

# find all proposals with references
search.ergmProposals(reference='Bernoulli')

# request proposals that mention triangle in the ergm package
search.ergmProposals('MH algorithm', packages='ergm')
}
}
\seealso{
See also \code{\link{ergmTerm}},
\code{\link{ergmConstraint}}, \code{\link{ergmReference}}, \code{\link{ergmHint}}, and
\code{\link{ergmProposal}}, for lists of terms and term-alikes visible to \pkg{ergm}.
}
\author{
skyebend@uw.edu
}
