% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm_proposal.R
\name{ergm_proposal}
\alias{ergm_proposal}
\alias{ergm_proposal.NULL}
\alias{ergm_proposal.ergm_proposal}
\alias{ergm_proposal.character}
\alias{ergm_proposal.formula}
\alias{ergm_proposal.term_list}
\alias{ergm_proposal.ergm_conlist}
\alias{ergm_proposal.ergm}
\title{Functions to initialize the ergm_proposal object}
\usage{
ergm_proposal(object, ...)

\method{ergm_proposal}{character}(
  object,
  arguments,
  nw,
  ...,
  reference = ergm_reference(trim_env(~Bernoulli), nw, term.options = term.options, ...),
  term.options = list()
)

\method{ergm_proposal}{formula}(
  object,
  arguments,
  nw,
  hints = trim_env(~sparse),
  ...,
  term.options = list()
)

\method{ergm_proposal}{term_list}(
  object,
  arguments,
  nw,
  hints = trim_env(~sparse),
  ...,
  term.options = list()
)

\method{ergm_proposal}{ergm_conlist}(
  object,
  arguments,
  nw,
  weights = "default",
  class = "c",
  reference = trim_env(~Bernoulli),
  ...,
  term.options = list()
)

\method{ergm_proposal}{ergm}(
  object,
  ...,
  constraints = NULL,
  arguments = NULL,
  nw = NULL,
  weights = NULL,
  class = "c",
  reference = NULL
)
}
\arguments{
\item{object}{Either a character, a \code{\link{formula}} or an
\code{\link{ergm}} object.  The \code{\link{formula}} should be of the format documented in the \code{constraints} argument of \code{\link[=ergm]{ergm()}} and in the \link[=ergmConstraint]{ERGM constraints} documentation.}

\item{\dots}{Further arguments passed to other functions.}

\item{arguments}{A list of parameters used by the InitErgmProposal routines}

\item{nw}{The network object originally given to \code{\link[=ergm]{ergm()}}
via 'formula'}

\item{reference}{A one-sided formula specifying
the reference measure (\eqn{h(y)}) to be used.
See help for \link[=ergm-references]{ERGM reference measures} implemented in the
\strong{\link[=ergm-package]{ergm}} package.}

\item{term.options}{A list of additional arguments to be passed to term initializers. See \code{\link[=term.options]{? term.options}}.}

\item{weights}{Specifies the method used to allocate probabilities
of being proposed to dyads, providing an intermediate method
(between hints and specifying the proposal name directly) for
specifying the proposal; options include "TNT", "StratTNT",
"TNT10", "random", "nonobserved" and "default"; default="default"}

\item{class}{The class of the proposal; choices include "c", "f",
and "d" default="c".}

\item{constraints}{A one-sided formula specifying one or more constraints on
the support of the distribution of the networks being simulated. See the
documentation for a similar argument for \code{\link[=ergm]{ergm()}} and see
\code{\link{ergmConstraint}} for more information.}
}
\value{
Returns an ergm_proposal object: a list with class \code{ergm_proposal}
containing the following named elements:
\item{name}{the C name of the proposal}
\item{inputs}{inputs to be passed to C}
\item{pkgname}{shared library name where the proposal
can be found (usually \code{"ergm"})}
\item{reference}{the reference distribution}
\item{arguments}{list of arguments passed to
the \code{InitErgmProposal} function; in particular,
\describe{
\item{\code{constraints}}{list of constraints}
\item{uid}{a string generated with the proposal, \UIDalgo; different proposals are, generally, guaranteed to have different strings, but identical proposals are not guaranteed to have the same string}
}
}
}
\description{
S3 Functions that initialize the Metropolis-Hastings Proposal (ergm_proposal)
object using the \verb{InitErgmProposal.*} function that corresponds to the name given in
'object'.  These functions are not generally called directly by the user.
See \code{\link{ergmProposal}} for general explanation and lists of available
Metropolis-Hastings proposal types.
}
\section{Methods (by class)}{
\itemize{
\item \code{ergm_proposal(character)}: \code{object} argument is a character string
giving the \R name of the proposal.

\item \code{ergm_proposal(formula)}: \code{object} argument is an ERGM constraint formula; constructs the \code{\link{ergm_conlist}} object and hands off to \code{ergm_proposal.ergm_conlist()}.

\item \code{ergm_proposal(term_list)}: \code{object} argument is a \code{\link[statnet.common:term_list]{term_list}};
same implementation as the \code{formula} method.

\item \code{ergm_proposal(ergm_conlist)}: \code{object} argument is an ERGM constraint
list; constructs the internal \code{ergm_reference} object, looks up the
proposal, and hands off to \code{ergm_proposal.character()}.

\item \code{ergm_proposal(ergm)}: \code{object} argument is an \code{\link{ergm}} fit whose proposals are extracted which is reproduced as best as possible.

}}
\seealso{
\code{\link{InitErgmProposal}}
}
\keyword{internal}
\keyword{models}
