% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm-options.R
\name{ergm-options}
\alias{ergm-options}
\alias{term.options}
\alias{ergmTerm-options}
\title{Global options and term options for the \code{ergm} package}
\description{
Options set via the built-in \code{\link[=options]{options()}} functions that affect \code{ergm} estimation and options that control the behavior of some terms.
}
\section{Global options and defaults}{


\describe{

\item{ergm.eval.loglik = TRUE}{Whether \code{\link[=ergm]{ergm()}} and similar functions will evaluate the likelihood of the fitted model. Can be overridden for a specific call by passing \code{eval.loglik} argument directly.}

\item{\code{ergm.loglik.warn_dyads = TRUE}}{Whether log-likelihood evaluation should issue a warning when the effective number of dyads that can vary in the sample space is poorly defined, such as if the degree sequence is constrained.}

\item{\code{ergm.cluster.retries = 5}}{\CRANpkg{ergm}'s parallel routines implement rudimentary fault-tolerance. This option controls the number of retries for a cluster call before giving up.}

\item{\code{ergm.term = list()}}{The default term options below.}

}
}

\section{Term options}{


Term options can be set in three places, in the order of precedence from high to low:
\enumerate{
\item As a term argument (not always). For example, \code{gw.cutoff} below can be set in a \ergmTerm{ergm}{gwesp}{} term by \code{gwesp(..., cutoff=X)}.
\item For functions such as \code{\link[=summary_formula.network]{summary}} that take \code{ergm} formulas but do not take a control list, the named arguments passed in as \code{...}. E.g, \code{summary(nw~gwesp(.5,fix=TRUE), gw.cutoff=60)} will evaluate the GWESP statistic with its cutoff set to 60.
\item As an element in a \verb{term.options=} list passed via a control function such as \code{\link[=control.ergm]{control.ergm()}} or, for functions that do not, in a list with that argument name. E.g., \code{summary(nw~gwesp(.5,fix=TRUE), term.options=list(gw.cutoff=60))} has the same effect.
\item As an element in a global option list \code{ergm.term} above.
}

The following options are in use by terms in the \code{ergm} package:

\describe{

\item{\code{version}}{A string that can be interpreted as an \R package version. If set, the term will attempt to emulate its behavior as it was that version of \code{ergm}. Not all past version behaviors are available.}

\item{\code{gw.cutoff}}{In geometrically weighted terms (\code{gwesp}, \code{gwdegree}, etc.) the highest number of shared partners, degrees, etc. for which to compute the statistic. This usually defaults to 30.}

\item{\code{cache.sp}}{Whether the \ergmTerm{ergm}{gwesp}{}, \ergmTerm{ergm}{dgwesp}{}, and similar terms need should use a cache for the dyadwise number of shared partners. This usually improves performance significantly at a modest memory cost, and therefore defaults to \code{TRUE}, but it can be disabled.}

\item{\code{interact.dependent}}{Whether to allow and how to handle the user attempting to interact dyad-dependent terms (e.g., \code{absdiff("age"):triangles} or \code{absdiff("age")*triangles} as opposed to \code{absdiff("age"):nodefactor("sex")}). Possible values are \code{"error"} (the default), \code{"message"}, and \code{"warning"}, for their respective actions, and \code{"silent"} for simply processing the term.}

}
}

