% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.dyad.independent.R
\name{is.dyad.independent}
\alias{is.dyad.independent}
\alias{is.dyad.independent.NULL}
\alias{is.dyad.independent.formula}
\alias{is.dyad.independent.ergm_conlist}
\alias{is.dyad.independent.ergm}
\title{Testing for dyad-independence}
\usage{
is.dyad.independent(object, ...)

\method{is.dyad.independent}{`NULL`}(object, ...)

\method{is.dyad.independent}{formula}(object, response = NULL, basis = NULL, ...)

\method{is.dyad.independent}{ergm_conlist}(object, object.obs = NULL, ...)

\method{is.dyad.independent}{ergm}(object, how = c("overall", "terms", "space"), ...)
}
\arguments{
\item{object}{The object to be tested for dyadic independence.}

\item{\dots}{Unused at this time.}

\item{response}{Either a character string, a formula, or \code{NULL} (the default), to specify the response attributes and whether the ERGM is binary or valued. Interpreted as follows: \describe{

\item{\code{NULL}}{Model simple presence or absence, via a binary ERGM.}

\item{character string}{The name of the edge attribute whose value is to be modeled. Type of ERGM will be determined by whether the attribute is \code{\link{logical}} (\code{TRUE}/\code{FALSE}) for binary or \code{\link{numeric}} for valued.}

\item{a formula}{must be of the form \code{NAME~EXPR|TYPE} (with \code{|} being literal). \code{EXPR} is evaluated in the formula's environment with the network's edge attributes accessible as variables. The optional \code{NAME} specifies the name of the edge attribute into which the results should be stored, with the default being a concise version of \code{EXPR}. Normally, the type of ERGM is determined by whether the result of evaluating \code{EXPR} is logical or numeric, but the optional \code{TYPE} can be used to override by specifying a scalar of the type involved (e.g., \code{TRUE} for binary and \code{1} for valued).}

}}

\item{basis}{See \code{\link[=ergm]{ergm()}}.}

\item{object.obs}{For the \code{\link{ergm_conlist}} method, the observed data constraint.}

\item{how}{one of \code{"overall"} (the default), \code{"terms"}, or
"\code{space}", to specify which aspect of the ERGM is to be tested
for dyadic independence.}
}
\value{
\code{TRUE} if the model implied by the object is
dyad-independent; \code{FALSE} otherwise.
}
\description{
These functions test whether an ERGM fit, a formula, or some other
object represents a dyad-independent model.

The method for \code{NULL} always returns \code{TRUE} by
convention.
}
\details{
Dyad independence is determined by checking if all of the
constituent parts of the object (formula, ergm terms, constraints,
etc.) are flagged as dyad-independent.
}
\keyword{model}
