% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_use_dates.R
\name{get_use_dates}
\alias{get_use_dates}
\title{Get dates for which to use (trust) inferred daily reports}
\usage{
get_use_dates(cl.daily, cl.input, prm.daily.check, dates.only = TRUE)
}
\arguments{
\item{cl.daily}{Data frame. Output of \code{\link[=agg_to_daily]{agg_to_daily()}}.}

\item{cl.input}{Data frame. Must have variables:
\itemize{
\item \code{date}: calendar date of report
\item \code{value}: count of reported cases
}}

\item{prm.daily.check}{List. Parameters for checking aggregated to daily report inference. Elements include:
\itemize{
\item \code{agg.reldiff.tol}: numerical tolerance (\%) for relative error between aggregated inferred daily reports and original aggregated reports; chronological observations are dropped until this tolerance is first acheived (convergence at the start of the timeseries is often the worst, need to maintain uninterrupted daily timeseries for input into Rt calculation).
}
Set this entire argument to \code{NULL} to use inferred daily reports as is.}

\item{dates.only}{Logical. Return use dates only or all columns of \code{cl.daily}.}
}
\value{
Data frame or vector, depending on \code{dates.only}
}
\description{
Get dates for which to use (trust) inferred daily reports
}
\keyword{internal}
