#' Network and Actor Attributes in Early Adolescence
#'
#' This dataset contains network and actor attributes collected in early adolescence.
#' It is provided by Andrea Knecht and stored in the package.
#'
#'
#' @source Knecht, A. (2004). *Network and actor attributes in early adolescence*. 
#' DANS Data Station Social Sciences and Humanities. 
#' DOI: \doi{10.17026/dans-z9b-h2bp}.
#'
#' @usage data("dutch_school")
#' @keywords datasets
#'
"dutch_school"

#' Sampson's Monk Network Data
#'
#' This dataset represents the social network of relationships among monks in a monastery,
#' as studied by Samuel F. Sampson. The data were collected during a period of instability
#' and document both positive and negative interactions among the monks.
#'
#'
#' @details
#' The study recorded friendships, antagonisms, and other social relationships among the monks
#' before and after a significant schism occurred in the monastery.
#'
#' @source
#' Sampson, S. F. (1969). *Crisis in a cloister*. Unpublished Ph.D. dissertation, Cornell University.
#'
#' @usage data("samplike")
#' @aliases sampson
#' @keywords datasets
#'
"samplike"
