% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Peaks.R
\name{p.measures}
\alias{p.measures}
\title{Calculate grand average and individual peak amplitude and latency}
\usage{
p.measures(data, electrodes, window, num.pts = 10)
}
\arguments{
\item{data}{A data frame in the format returned from \code{\link{load.data}}}

\item{electrodes}{A single value or concatenation of several values (to be averaged)
indicating which electrodes to include in generating the plot. At this time, if the
raw data files imported using \code{\link{load.data}}) do not have a header, you
must include a capital "V" in front of the number and enclose each electrode in quotes.
(For example, electrodes = "V78", or electrodes = c("V78", "V76").)}

\item{window}{The beginning and end points of a time window of interest; this is different
from the beginning and ending times \code{epoch.st} and \code{epoch.end} defined in
\code{\link{load.data}} (you only need to define the epoch once upon importing the data).}

\item{num.pts}{The number of bins to check for local peak measures. If no local peaks are
  found, the simple peak will be returned. To force the simple peak, set \code{num.pts}
  to 0.}
}
\value{
A data frame with columns labeled:
\itemize{
    \item Subject
    \item Trial Type
    \item Peak Latency
    \item Peak Amplitude
}
}
\description{
\code{p.measures} calculates simple peak amplitude and latency for each condition
  in the data frame. Values are calculated for grand average waveforms, as well as
  for each individual subject. Values are based on the electrode, or electrode cluster for
  dense arrays, provided in \code{electrodes}. This function will identify the largest
  deviation from 0, whether positive or negative.
}
\details{
At this time there is no way to specify a negative or positive peak.
  \code{p.measures} simply returns the largest absolute value deviation from zero.
}
\examples{
# Calculate peak latency and amplitude
p.measures(ERPdata, electrodes = "V78", window = c(1000, 1500))
}
\author{
Travis Moore
}

