% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_intervals.R
\name{df_intervals.default}
\alias{df_intervals.default}
\title{Data Frames of Intervals}
\usage{
\method{df_intervals}{default}(distributions, errs)
}
\arguments{
\item{distributions}{vector containing the names of the distribution
correspondind to each error.}

\item{errs}{vector of errors associated to intervals built under
a particular distribution assumption indicated by 'distributions'.}
}
\value{
Returns an object of class \code{c("df_intervals", "data.frame")}
with information regarding the error of intervals built under
different distribution assumptions.
}
\description{
\code{df_intervals} creates an object of class
 \code{c("df_intervals", "data.frame")}.
}
\examples{
df_intervals("l",0.1)

df_intervals(c("l","lm","n","nm","b","w"),rep(0.1,6))
}
\author{
Jesus Prada, \email{jesus.prada@estudiante.uam.es}
}
\references{
Link to the scientific paper

Prada, Jesus, and Jose Ramon Dorronsoro. "SVRs and Uncertainty Estimates in Wind 
Energy Prediction." Advances in Computational Intelligence. Springer International 
Publishing, 2015. 564-577,

with theoretical background for this package is provided below.

\url{http://link.springer.com/chapter/10.1007/978-3-319-19222-2_47}
}

