% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{cbind.errors}
\alias{cbind.errors}
\alias{rbind.errors}
\title{Combine \R Objects by Rows or Columns}
\usage{
\method{cbind}{errors}(..., deparse.level = 1)

\method{rbind}{errors}(..., deparse.level = 1)
}
\arguments{
\item{...}{(generalized) vectors or matrices.  These can be given as named
    arguments.  Other \R objects may be coerced as appropriate, or S4
    methods may be used: see sections \sQuote{Details} and
    \sQuote{Value}.  (For the \code{"data.frame"} method of \code{cbind}
    these can be further arguments to \code{\link{data.frame}} such as
    \code{stringsAsFactors}.)}

\item{deparse.level}{integer controlling the construction of labels in
    the case of non-matrix-like arguments (for the default method):\cr
    \code{deparse.level = 0} constructs no labels; the default,\cr
    \code{deparse.level = 1 or 2} constructs labels from the argument
    names, see the \sQuote{Value} section below.}
}
\description{
S3 methods for \code{errors} objects (see \code{\link[base]{cbind}}).
}
\examples{
x <- set_errors(1, 0.1)
y <- set_errors(1:3, 0.2)
(m <- cbind(x, y)) # the '1' (= shorter vector) is recycled
(m <- cbind(m, 8:10)[, c(1, 3, 2)]) # insert a column
cbind(y, diag(3)) # vector is subset -> warning
cbind(0, rbind(x, y))

}
\seealso{
\code{\link{c.errors}}
}
