% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esDesign.R
\name{SSR.sim}
\alias{SSR.sim}
\title{Conduct the simulation studies using SSR}
\usage{
SSR.sim(N, rho, alpha, beta, theta, theta0, sigma0, pstar, nSim, Seed)
}
\arguments{
\item{N}{The sample size used at the first stage. Note that this \code{N} is
not the initial total sample size calculated using the standard design}

\item{rho}{The proportion of subgroup 1}

\item{alpha}{The overall Type I error rate}

\item{beta}{The \code{(1 - Power)}}

\item{theta}{The sizes of treatment effects for subgroups 1 and 2 in the
experimental arm}

\item{theta0}{The size of treatment effect in the control arm}

\item{sigma0}{The variance of the treatment effect}

\item{pstar}{The \code{(1 - power)} of accepting the null hypothesis at the
interim analysis.}

\item{nSim}{The number of simulated studies}

\item{Seed}{The random seed}
}
\value{
A list contains
\itemize{
  \item nTotal The average total sample size used in SSR
  \item H0 The power of SSR under the specific trial design. Here, the power
     is defined as the probability of rejecting the null hypothesis
  \item ESF The percentage of early stopping for futility
  \item ESE The percentage of early stopping for efficacy
}
}
\description{
The \code{SSR.sim()} is used to implement the simulation studies
   based on the Sample Size Re-estimation Procedure.
}
\examples{
N <- 310
rho <- 0.5
alpha <- 0.05
beta <- 0.2
pstar <- 0.2
theta <- c(0.2,0)
theta0 <- 0
sigma0 <- 1.0
nSim <- 1000
Seed <- 6
SSR.sim(N = N, rho = rho, alpha = alpha, beta = beta, theta = theta,
        theta0 = theta0, sigma0 = sigma0, pstar = pstar,
        nSim = nSim, Seed = Seed)
}
\references{
\itemize{
 \item Proschan MA, Hunsberger SA. Designed extension of studies based on
    conditional power. Biometrics 1995:1315-1324. <doi:10.2307/2533262>
}
}
