% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esDesign.R
\name{AED3_SSR.boundary}
\alias{AED3_SSR.boundary}
\title{Calculate the futility and efficacy stopping boundaries in Adaptive
  enrichment design (Strategy 3) with Sample Size Re-estimation Procedure
  for the continuous endpoint}
\usage{
AED3_SSR.boundary(rho, alpha, pstar)
}
\arguments{
\item{rho}{The proportion of subgroup 1}

\item{alpha}{The overall Type I error rate}

\item{pstar}{The \code{(1 - power)} of accepting the null hypothesis at the
interim analysis.}
}
\value{
A list contains
\itemize{
  \item upper.boundary The upper or the efficacy stopping boundary
  \item lower.boundary The lower or the futility stopping boundary
}
}
\description{
The \code{AED3_SSR.boundary()} is used to calculate the futility
  and efficacy stopping boundaries in the Adaptive Enrichment Design with
  Sample Size Re-estimation Procedure.
}
\examples{
rho <- 0.5
alpha <- 0.05
pstar <- 0.15
res <- AED3_SSR.boundary(rho = rho, alpha = alpha, pstar = pstar)
}
