## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 7, fig.height = 5
)

## ---- message=FALSE-----------------------------------------------------------
library(escalation)

model <- get_boin(num_doses = 5, target = 0.3)

## -----------------------------------------------------------------------------
model <- get_boin(num_doses = 5, target = 0.3, p.saf = 0.18, p.tox = 0.42)

## -----------------------------------------------------------------------------
fit <- model %>% fit('1NNN')

## -----------------------------------------------------------------------------
fit %>% recommended_dose()

## -----------------------------------------------------------------------------
fit <- model %>% fit('1NNN 2NNN')
fit %>% recommended_dose()

## -----------------------------------------------------------------------------
fit <- model %>% fit('1NNN 2NNN 3NTT')
fit %>% recommended_dose()

## -----------------------------------------------------------------------------
fit %>% dose_admissible()

## -----------------------------------------------------------------------------
cohort_sizes <- c(3, 3)
paths <- model %>% get_dose_paths(cohort_sizes = cohort_sizes, 
                                  previous_outcomes = '1NNN', next_dose = 2)
graph_paths(paths)

## -----------------------------------------------------------------------------
model <- get_boin(num_doses = 6, target = 0.25) %>% 
  stop_at_n(n = 36)

## -----------------------------------------------------------------------------
true_prob_tox <- c(0.25, 0.35, 0.5, 0.6, 0.7, 0.8)

## -----------------------------------------------------------------------------
num_sims <- 50

## -----------------------------------------------------------------------------
sims <- model %>% 
  simulate_trials(num_sims = num_sims, true_prob_tox = true_prob_tox)

## -----------------------------------------------------------------------------
prob_recommend(sims)

## -----------------------------------------------------------------------------
colMeans(n_at_dose(sims))

