% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_d1.R
\name{meta_d1}
\alias{meta_d1}
\title{Estimate a meta-analytic Cohen's d1 across multiple studies}
\usage{
meta_d1(
  data,
  ds,
  ns,
  labels = NULL,
  moderator = NULL,
  contrast = NULL,
  effect_label = "My effect",
  random_effects = TRUE,
  conf_level = 0.95
)
}
\arguments{
\item{data}{A data frame or tibble}

\item{ds}{Set of bias-adjusted cohen's d1 values, 1 for each study}

\item{ns}{Set of sample sizes, positive integers, 1 for each study}

\item{labels}{Optional set of labels, 1 for each study}

\item{moderator}{Optional factor as a categorical moderator; should have k >
2 per group}

\item{contrast}{Optional vector specifying a contrast between moderator
levels}

\item{effect_label}{Optional character providing a human-friendly label for
the effect}

\item{random_effects}{Boolean; TRUE for a random effects model; otherwise
fixed effects}

\item{conf_level}{The confidence level for the confidence interval.  Given in
decimal form.  Defaults to 0.95.}
}
\value{
An esci-estimate object; a list of data frames and properties.
Returned tables include:
\itemize{
\item \strong{es_meta} - A data frame of meta-analytic effect sizes.  If a moderator was
defined, there is an additional row for each level of the moderator.
\itemize{
\item \emph{effect_label} -  Study label
\item \emph{effect_size} - Effect size
\item \emph{LL} - Lower bound of conf_level\% confidence interval
\item \emph{UL} - Upper bound of conf_level\% confidence interval
\item \emph{SE} - Expected standard error
\item \emph{k} - Number of studies
\item \emph{diamond_ratio} - ratio of random to fixed effects meta-analytic effect sizes
\item \emph{diamond_ratio_LL} - lower bound of conf_level\% confidence interval for diamond ratio
\item \emph{diamond_ratio_UL} - upper bound of conf_level\% confidence interval for diamond ratio
\item \emph{I2} -  I2 measure of heterogeneity
\item \emph{I2_LL} - Lower bound of conf_level\% confidence interval for I2
\item \emph{I2_UL} - upper bound of conf_level\% confidence interval for I2
\item \emph{PI_LL} - lower bound of conf_level\% of prediction interval
\item \emph{PI_UL} - upper bound of conf_level\% of prediction interval
\item \emph{p} - p value for the meta-analytic effect size, based on null of exactly 0
\item *width - width of the effect-size confidence interval
\item \emph{FE_effect_size} - effect size of the fixed-effects model (regardless of if fixed effects was selected
\item \emph{RE_effect_size} - effect size of the random-effects model (regardless of if random effects was selected
\item \emph{FE_CI_width} - width of the fixed-effects confidence interval, used to calculate diamond ratio
\item \emph{RE_CI_width} - width of the fixed-effects confidence interval, used to calculate diamond ratio
}
\item \strong{es_heterogeneity} - A data frame of of heterogeneity values and
conf_level\% CIs for the meta-analytic effect size.  If a moderator was defined
also reports heterogeneity estimates for each level of the moderator.
\itemize{
\item \emph{effect_label} - study label
\item \emph{moderator_variable_name} - if moderator passed, gives name of the moderator
\item \emph{moderator_level} - 'Overall' and each level of moderator, if passed
\item \emph{measure} - Name of the measure of heterogeneity
\item \emph{estimate} - Value of the heterogeneity estimate
\item \emph{LL} - lower bound of conf_level\% confidence interval
\item \emph{UL} - upper bound of conf_level\% confidence interval
}
\item \strong{raw_data} - A data from with one row for each study that was passed
\itemize{
\item \emph{label} - study label
\item \emph{effect_size} - effect size
\item \emph{weight} - study weight in the meta analysis
\item \emph{sample_variance} - expected level of sampling variation
\item \emph{SE} - expected standard error
\item \emph{LL} - lower bound of conf_level\% confidence interval
\item \emph{UL} - upper bound of conf_level\% confidence interval
\item \emph{mean} - used to calculate study p value; this is the d value entered for the study
\item \emph{sd} - use to calculate study p value; set to 1 for each study
\item \emph{n} - study sample size
\item \emph{p} - p value for the study, based on null of exactly 0
}
}
}
\description{
\code{meta_d1} is suitable for synthesizing across multiple
single-group studies with a continuous outcome variable, but where the
outcome is not measured on the same scale in all studies
}
\details{
Once you generate an estimate with this function, you can visualize
it with \code{\link[=plot_meta]{plot_meta()}}.

Each study's effect size should be expressed as Cohen's
d1: (mean - reference) / sd.

And the d1 values should all be corrected for bias.
The function \code{\link[=CI_smd_one]{CI_smd_one()}} can assist with converting raw data from
each study to d1_unbiased.

The meta-analytic effect size, confidence interval and heterogeneity
estimates all come from \code{\link[metafor:rma.uni]{metafor::rma()}}.

The diamond ratio and its confidence interval come from
\code{\link[=CI_diamond_ratio]{CI_diamond_ratio()}}.
}
\examples{
# example code
  original_7 <- data.frame(
study_name = c(
  "Aden (1993)"	,
  "Buggs (1995)"	,
  "Crazed (1999)"	,
  "Dudley (2003)"	,
  "Evers (2005)"	,
  "Fox (2009)",
  "Mine (2011)"
),
rt_mean = c(
  454	,
  317	,
  430	,
  525	,
  479	,
  387,
  531
),
rt_sd = c(
  142	,
  158	,
  137	,
  260	,
  144	,
  165,
  233
),
rt_n = c(
  24	,
  7	,
  20	,
  8	,
 14	,
 13,
  18
),
subset = as.factor(
  c(
    "90s",
   "90s",
    "90s",
    "00s",
    "00s",
    "00s",
    "00s"
  )
),
d1_unbiased = c(
  3.091587,
  1.742751,
  3.012857,
  1.793487,
  3.130074,
  2.195209,
  2.17667
)
)


# Fixed effect, 95\% CI
estimate <- esci::meta_d1(
  original_7,
  d1_unbiased,
  rt_n,
  study_name,
  random_effects = FALSE
)

# Forest plot
myplot_forest <- esci::plot_meta(estimate)


# Add a moderator
estimate_moderator <- esci::meta_d1(
  data = original_7,
  ds = d1_unbiased,
  ns = rt_n,
  moderator = subset,
  labels = study_name,
  random_effects = FALSE
)

# Forest plot
myplot_forest_moderator <- esci::plot_meta(estimate_moderator)


}
