% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data_meditationbrain}
\alias{data_meditationbrain}
\title{MeditationBrain - Ch15 - from Holzel et al. (2011)}
\format{
\subsection{\code{data_meditationbrain}}{

A data frame with 33 rows and 7 columns:
\describe{
\item{Pretest}{numeric}
\item{Posttest}{numeric}
\item{Group}{factor}
\item{ControlPre}{numeric}
\item{ControlPost}{numeric}
\item{MeditationPre}{numeric}
\item{MeditationPost}{numeric}
}
}
}
\source{
\doi{10.1007/978-94-007-2079-4_9}
}
\usage{
data_meditationbrain
}
\description{
My example is a well-known study of mindfulness meditation by Holzel et al.
(2011). People who wanted to reduce stress, and were not experienced
meditators, were assigned to a Meditation (n = 16) or a Control (n = 17)
group. The Meditation group participated in 8 weeks of intensive training and
practice of mindfulness meditation. The researchers used a questionnaire to
assess a range of emotional and cognitive variables both before (Pretest) and
after (Posttest) the 8-week period. All assessment was conducted while the
participants were not meditating. The study is notable for including brain
imaging to assess possible changes in participants' brains from Pretest to
Posttest. The researchers measured gray matter concentration, which increases
in brain regions that experience higher and more frequent activation. The
researchers expected that the hippocampus may be especially responsive to
meditation because it has been implicated in the regulation of emotion,
arousal, and general responsiveness. They therefore included in their planned
analysis the assessment of any changes to gray matter concentration in the
hippocampus.
}
\keyword{datasets}
