% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_spectrogram.R
\name{signal_spectrogram}
\alias{signal_spectrogram}
\title{Calculate spectrograms (power spectral density estimates) from time series.}
\usage{
signal_spectrogram(
  data,
  time,
  dt,
  Welch = FALSE,
  window,
  overlap = 0.5,
  window_sub,
  overlap_sub = 0.5,
  method = "periodogram",
  nw = 4,
  k = 7,
  n_cores = 1,
  plot = FALSE,
  ...
)
}
\arguments{
\item{data}{\code{Numeric} vector or list of vectors, seismic signal to 
be processed.}

\item{time}{\code{POSIX.ct} vector with time values. If omitted, an 
artificial time vector will be created, based on \code{dt}. Only needed 
if \code{data} is no \code{eseis} object.}

\item{dt}{\code{Numeric} value, sampling period. If omitted, either 
estimated from \code{time} or set to 0.01 s (i.e., f = 100 Hz). Only needed 
if \code{data} is no \code{eseis} object.}

\item{Welch}{\code{Logical} value, option to use the Welch method for
calculations.}

\item{window}{\code{Numeric} value, time window length in seconds used to 
calculate individual spectra. Set to 1 percent of the time series length 
by default.}

\item{overlap}{\code{Numeric} value, fraction of window overlap.}

\item{window_sub}{\code{Numeric} value, length of the sub-window in seconds 
used to calculate spectra. Only relevant if \code{Welch = TRUE}. If omitted, 
the sub-window length is set to 10 percent of the main window length.}

\item{overlap_sub}{\code{Numeric} value, fraction of sub-window overlap.}

\item{method}{\code{Character} value, method to calculate the spectra. 
One out of \code{"periodogram"}, \code{"autoregressive"} and 
\code{"multitaper"}. Default is \code{"periodogram"}.}

\item{nw}{\code{Numeric} value, multitaper time-bandwidth parameter,
default is 4.0.}

\item{k}{\code{Numeric} value, multitaper number of tapers, default is 7.}

\item{n_cores}{\code{Numeric} value, number of CPU cores to use. Disabled 
by setting to 1. Default is 1.}

\item{plot}{\code{Logical} value, toggle plot output. Default is
\code{FALSE}. For more customised plotting see \code{plot_spectrogram}.}

\item{\dots}{Additional arguments passed to the function.}
}
\value{
\code{List} with spectrogram matrix, time and frequency vectors.
}
\description{
This function creates spectrograms from seismic signals. It supports the
standard spectrogram approach, multitaper, and the Welch method.
}
\details{
Data containing \code{NA} values is replaced by zeros and set to NA in the 
output data set.
}
\examples{

## load example data set
data("earthquake")

## calculate and plot PSD straight away
P <- signal_spectrogram(data = s$BHZ, 
                               time = t, 
                               dt = 1 / 200, 
                               plot = TRUE)

## calculate and plot PSD with defined window sizes and the Welch method
P <- signal_spectrogram(data = s$BHZ, 
                               time = t, 
                               dt = 1 / 200, 
                               window = 5, 
                               overlap = 0.9, 
                               window_sub = 3, 
                               overlap_sub = 0.9, 
                               Welch = TRUE,
                               plot = TRUE)
                               
## calculate and plot PSD with even smaller window sizes, the Welch
## method and using multitapers, uncomment to use.
# P <- signal_spectrogram(data = s$BHZ, 
#                                time = t, 
#                                dt = 1 / 200, 
#                                window = 2, 
#                                overlap = 0.9, 
#                                window_sub = 1, 
#                                overlap_sub = 0.9, 
#                                Welch = TRUE,
#                                method = "multitaper",
#                                plot = TRUE)
                      
}
\seealso{
\code{\link{spectrum}}, \code{\link{spec.pgram}}, 
\code{\link{spec.mtm}}
}
\author{
Michael Dietze
}
\keyword{eseis}
