% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebook_table.R
\name{codebook_table}
\alias{codebook_table}
\title{Create Codebook Table}
\usage{
codebook_table(
  df,
  origin_cbook = NULL,
  origin_vars = "Variable",
  n_unique_thres = 6,
  include_txt = FALSE,
  include_date = TRUE,
  histograms = TRUE,
  boxplots = TRUE,
  html_output = NULL,
  kable_out = TRUE
)
}
\arguments{
\item{df}{The dataframe for which the codebook table is generated.}

\item{origin_cbook}{A dataframe of a hand-maid codebook table that is stored in an csv of xlsx file.
The file must be first imported in the R session.
If the variable containing the basis codebook, the resulting codebook table will include
the original codebook information.
This allows merging and incorporating a hand-made codebook into the output.
Default is \code{NULL}.}

\item{origin_vars}{A character string specifying the name of the variable column in the \code{origin_cbook}.
Default is "Variable".}

\item{n_unique_thres}{The threshold for the number of unique values to consider a variable as categorical.
Default is 6.}

\item{include_txt}{Logical indicating whether to include text variable statistics in the codebook table.
Default is \code{FALSE}.}

\item{include_date}{Logical indicating whether to include date variable statistics in the codebook table.
Default is \code{TRUE}.}

\item{histograms}{Logical indicating whether to include histograms in the codebook table.
Default is \code{TRUE}.}

\item{boxplots}{Logical indicating whether to include boxplots in the codebook table.
Default is \code{TRUE}.}

\item{html_output}{Define a file name (e.g., "path/to/codebook_table.html") to create an html output version of the codebook table.}

\item{kable_out}{When TRUE, output is in kable version. If FALSE, use DT package.}
}
\value{
A a codebook table generated using kable or the DT package.
}
\description{
The \code{codebook_table()} function generates a codebook table for a given dataframe,
providing descriptive statistics and visualizations for each variable.
See an example here: \url{https://preprocess.esmtools.com/pages/90_Codebook_table_esmtools.html}.
}
\examples{
if (interactive()) {
 # Load library 
 library(esmtools)
 library(readxl) 

 # Load the hand-made codebook
 path_original <- system.file("extdata", "cbook_part1.xlsx", package = "esmtools")
 original_codebook <- read_excel(path_original)

 # Create codebook table based on the hand-made codebook and the dataset
 \donttest{codebook_table(df = esmdata_sim, origin_cbook = original_codebook)}
}
}
