% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatcalendar_plot.R
\name{heatcalendar_plot}
\alias{heatcalendar_plot}
\title{Generate a heatmap calendar plot}
\usage{
heatcalendar_plot(
  .data,
  timevar = NULL,
  week_start = getOption("lubridate.week.start", 1)
)
}
\arguments{
\item{.data}{A dataframe that contains the time variable}

\item{timevar}{The time variable name}

\item{week_start}{When set to 1 (by default), the week starts on Monday, when set to 7, the week starts on Sunday following USA calendar.}
}
\value{
A heatmap calendar plot
}
\description{
The 'heatcalendar_plot()' function creates a heatmap-style calendar visualization that represents the density of events over time.
Each cell in the heatmap represents a specific day, and its color intensity reflects the number of events that occurred on that day.
This function utilizes the 'ggplot2' R package to create the heatmap calendar plot.
}
\details{
The 'heatcalendar_plot()' function generates a heatmap-style calendar plot where each cell corresponds to a day of the year. The color intensity of each cell represents the event density, allowing for the identification of patterns and trends in event occurrences over time.
}
\examples{
if (interactive()) {
  esmdata_sim$sent <- as.POSIXct(as.character(esmdata_sim$sent))
  heatcalendar_plot(esmdata_sim, timevar = "sent")
}
}
