% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_legend.R
\name{display.legend}
\alias{display.legend}
\title{Display of the RoI legend}
\usage{
display.legend(
  struct = NULL,
  roi.name = NULL,
  roi.sname = NULL,
  roi.idx = NULL,
  lwd = 1,
  cex = 1,
  displayed.roi.name = NULL,
  bg = "black"
)
}
\arguments{
\item{struct}{"struct" class object.}

\item{roi.name}{Vector of exact names of the RoI in the \code{struct} object.
By default \code{roi.name = NULL}. See Details.}

\item{roi.sname}{Vector of names or parts of names of the RoI in the
\code{struct} object. By default \code{roi.sname = NULL}. See Details.}

\item{roi.idx}{Vector of indices of the RoI that belong to the \code{struct}
object. By default \code{roi.idx = NULL}. See Details.}

\item{lwd}{Line thickness, defaults to 1}

\item{cex}{Font size, default to 1.}

\item{displayed.roi.name}{Vector. If different from \code{NULL}, it represents
the replacement names of selected RoI if needed.}

\item{bg}{color of the background.}
}
\value{
Returns  display of the RoI names and their associated color in the
active graphics window.
}
\description{
The \code{display.legend} function displays in an image the list
of requested RoI and their associated color.
}
\details{
\code{roi.name}, \code{roi.sname}, and \code{roi.idx}
indicates the RoI to display. If all three are set to NULL, all RoI are selected.
}
\examples{
# loading of toy-patient objects
patient <- toy.load.patient (modality = c("rtstruct"), dxyz = c (5, 5, 5))
S <- patient$rtstruct[[1]]

display.legend (struct = S, roi.idx = 2:10, lwd = 2)
}
