% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rt_gamma_index.R
\name{rt.gamma.index}
\alias{rt.gamma.index}
\title{Gamma index 2D - 3D}
\usage{
rt.gamma.index(
  vol,
  vol.ref,
  vol.max = vol.ref$max.pixel,
  dose.th = 0.02,
  delta.r = 3,
  analysis.th = 0.05,
  local = FALSE,
  local.th = 0.3,
  alias = "",
  description = NULL
)
}
\arguments{
\item{vol}{"volume" class object, which represents the measured volume.}

\item{vol.ref}{"volume" class object, which represents the reference volume.}

\item{vol.max}{Positive number, by default equal to the maximum value of the reference volume.
See Details.}

\item{dose.th}{Positive number, in percent, used to determine the dose difference criterion. See Details.}

\item{delta.r}{Positive number, in mm. Distance difference criterion.}

\item{analysis.th}{Positive number, in percent. Only the voxels whose value is
greater than or equal \code{analyse.th*vol.max} are processed.}

\item{local}{Boolean. If \code{local = FALSE} (default), a global Gamma index
is computed, and a local Gamma index otherwise.}

\item{local.th}{Positive number, in percent. Local threshold, only used if
\code{local = TRUE}. See Details.}

\item{alias}{Character string, \code{$object.alias} of the created object.}

\item{description}{Character string, describing the created object. If
\code{description = NULL} (default value), it will be set to Gamma index setup.
\loadmathjax}
}
\value{
Returns a "volume" class object (see \link[espadon]{espadon.class}
for class definitions).  The \code{$vol3D.data} field represents the Gamma index.
Two fields are added:
the \code{$setup} field recalls the calculation setup, and the \code{$gamma.info} field
details the rate of Gamma indices below 1, above 1.2 and 1.5, the max and the
mean Gamma index.
}
\description{
The \code{rt.gamma.index} function computes the local or global
Gamma index from a measurement and a reference. These latter are "volume" class
objects containing one (2D) or several planes (3D).
}
\details{
The Gamma index of a voxel \mjeqn{n}{ascii} was defined by \emph{Low and al} \strong{[1]}.
It is computed from the formulae:
\mjdeqn{\gamma_n = min \left( \sqrt{\frac{(D_i-Dref_n)^2}{{\Delta D}^2} + \frac{{r_i}^2}{{\Delta r}^2}}\right)}{ascii}
whith \mjeqn{D_i}{ascii} the measured dose at voxel \mjeqn{i}{ascii},
\mjeqn{Dref_n}{ascii} the reference dose at voxel \mjeqn{n}{ascii},
\mjeqn{r_i}{ascii} the distance between voxels \mjeqn{i}{ascii} and \mjeqn{n}{ascii},
\mjeqn{\Delta r}{ascii} the distance difference criterion equal to \code{delta.r},
\mjeqn{\Delta D}{ascii} the distance difference criterion at voxel \mjeqn{n}{ascii} defined as follows:
\itemize{
\item If \code{local = FALSE} a global Gamma index is computed and
\mjeqn{\Delta D~=~dose.th~\cdot~vol.max}{ascii}.
\item If \code{local = TRUE}, then \mjeqn{\Delta D~=~dose.th~\cdot~Dref_n}{ascii} when
\mjeqn{Dref_n~\ge~local.th~\cdot~vol.max}{ascii}, and
\mjeqn{\Delta D~=~dose.th~\cdot~local.th~\cdot~vol.max}{ascii} otherwise.
}
}
\examples{
# Creation of a reference volume  and measured volume
# loading of toy-patient objects (decrease dxyz for  better result)
patient <- toy.load.patient (modality = c ("rtdose", "rtstruct"), 
                             roi.name = "ptv", dxyz = c (3, 3, 3))
D.ref <- patient$rtdose[[1]]  
# We will assume that the measured dose is equal to the reference dose shifted
# by one pixel on the x axis
D.meas <- vol.copy (D.ref, alias = "measured_dose")
D.meas$vol3D.data[1:(D.meas$n.ijk[1] - 1) ,,] <- D.ref$vol3D.data[2:D.ref$n.ijk[1],,] 

gamma <- rt.gamma.index (D.meas, D.ref, delta.r = 6)  
gamma$gamma.info  

# Display gamma index at isocenter
G.iso <- patient$rtstruct[[1]]$roi.info$Gz[
  patient$rtstruct[[1]]$roi.info$name == "ptv"]
display.plane(gamma, view.coord = G.iso, 
              bottom.col = c ("#00FF00", "#007F00", "#FF8000", "#FF0000", 
                              "#AF0000"),
              bottom.breaks = c (0, 0.8, 1, 1.2, 1.5, gamma$max.pixel), 
              bg = "blue", interpolate = FALSE)
}
\references{
\strong{[1]} \insertRef{low1998}{espadon}
}
\seealso{
\link[espadon]{rt.chi.index}
}
