% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_patient_from_Rdcm.R
\name{load.patient.from.Rdcm}
\alias{load.patient.from.Rdcm}
\title{Loading patient data from *.Rdcm files}
\usage{
load.patient.from.Rdcm(
  dirname,
  data = FALSE,
  dvh = FALSE,
  upgrade.to.latest.version = FALSE,
  ignore.duplicates = FALSE
)
}
\arguments{
\item{dirname}{Full paths of the directories of a single patient, or vector
of full.path of Rdcm.files.}

\item{data}{Boolean. If \code{data = TRUE}, the voxels value of the "volume"
class objects, or the coordinates of the RoI (region of interest)
of the \code{struct} class objects, are loaded into memory.}

\item{dvh}{Boolean. if \code{dvh = TRUE} and if they exist, patient DVH are
loaded, for convenience. They are not used as is in \pkg{espadon} package.}

\item{upgrade.to.latest.version}{Boolean. If \code{TRUE}, the function attempts
to upgrade to the latest version, parsing the DICOM data. It may take longer
to load the data. Consider using the\link[espadon]{Rdcm.upgrade} function.}

\item{ignore.duplicates}{Boolean. If \code{TRUE}, the function ignores duplicated objects.}
}
\value{
Returns an \pkg{espadon} object of class "patient", describing the
information contained in \code{dirname}. See \link[espadon]{espadon.class} for a
description of the "patient" class.
}
\description{
The \code{load.patient.from.Rdcm} function is used to load or
pre-load in memory all patient objects converted in *.Rdcm files.
}
\examples{
# First, save toy patient objects to a temporary file pat.dir for testing.
pat.dir <- file.path (tempdir(), "PM_Rdcm") 
dir.create (pat.dir, recursive = TRUE) 
patient <- toy.load.patient (modality = c("ct", "mr"), roi.name = "", 
                             dxyz = c (4, 4, 4))
save.to.Rdcm (patient$ct[[1]], dirname = pat.dir)
save.to.Rdcm (patient$mr[[1]], dirname = pat.dir)
save.T.MAT (patient$T.MAT, dirname = pat.dir)
# Rdcm files in pat.dir
list.files(pat.dir)

# loading patient from Rdcm files with data: 
new.patient <- load.patient.from.Rdcm (pat.dir, data = TRUE)
str (new.patient, max.level = 2 )

# Cleaning  temporary directory
unlink (pat.dir, recursive = TRUE)
}
\seealso{
\link[espadon]{dicom.to.Rdcm.converter}, \link[espadon]{load.patient.from.dicom},
\link[espadon]{load.obj.data}, \link[espadon]{load.obj.from.dicom},
\link[espadon]{load.obj.from.Rdcm} and \link[espadon]{load.T.MAT}.
}
