% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_xyz_from_index.R
\name{get.xyz.from.index}
\alias{get.xyz.from.index}
\title{Conversion of the indices of a point, into xyz coordinate vector in the patient's
frame of reference}
\usage{
get.xyz.from.index(idx, vol)
}
\arguments{
\item{idx}{Index, or matrix of voxel indices in the array \code{vol$vol3D.data}.
The first index of the array is 1.}

\item{vol}{"volume" class object.}
}
\value{
Returns a column-matrix of coordinates in the patient's reference frame,
corresponding to the indices \code{idx}.
}
\description{
The \code{get.xyz.from.index} function converts the indices of a
voxel of \code{vol$vol3D.data} (for example, obtained with the function
\code{which}) into a vector or matrix of x, y, z coordinates in the patient's
frame of reference.
}
\examples{
# loading of toy-patient objects (decrease dxyz and increase beam.nb for better
# result)
step <- 4
patient <- toy.load.patient (modality = "rtdose", roi.name = "", 
                             dxyz = rep (step, 3), beam.nb = 3)
D <- patient$rtdose[[1]]

# voxels location where the dose is greater than 99.9\% Dmax
Dmax <- max (D$vol3D.data, na.rm = TRUE) # D$max.pixel
get.xyz.from.index (which (D$vol3D.data >= 0.99 * Dmax), D)
# or
get.xyz.from.index (which (D$vol3D.data >= 0.99 * Dmax, arr.ind = TRUE), D)
}
