% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-filterDF.R
\name{module-filterDF}
\alias{module-filterDF}
\alias{filterDF_UI}
\alias{filterDF}
\title{Shiny module to interactively filter a \code{data.frame}}
\usage{
filterDF_UI(id, show_nrow = TRUE)

filterDF(input, output, session, data_table = reactive(),
  data_vars = shiny::reactive(NULL), data_name = reactive("data"))
}
\arguments{
\item{id}{Module id. See \code{\link[shiny]{callModule}}.}

\item{show_nrow}{Show number of filtered rows and total.}

\item{input, output, session}{standards \code{shiny} server arguments.}

\item{data_table}{\code{\link[shiny]{reactive}} function returning a
\code{data.frame} to filter.}

\item{data_vars}{\code{\link[shiny]{reactive}} function returning a
\code{character} vector of variable to use for filters.}

\item{data_name}{\code{\link[shiny]{reactive}} function returning a
\code{character} string representing \code{data_table} name.}
}
\value{
A \code{list} with 2 elements :
 \itemize{
  \item \strong{data_filtered} : \code{\link[shiny]{reactive}} function returning data filtered.
  \item \strong{code} : \code{\link[shiny]{reactiveValues}} with 2 slots :
   \code{expr} (raw expression to filter data) and \code{dplyr} (code with dplyr pipeline).
 }
}
\description{
Module generate inputs to filter \code{data.frame} according column's type.
 Code to reproduce the filter is returned as an expression with filtered data.
}
\examples{
if (interactive()) {

library(shiny)
library(shinyWidgets)
library(ggplot2)
library(esquisse)


ui <- fluidPage(
  tags$h2("Filter data.frame"),
  
  radioButtons(
    inputId = "dataset", 
    label = "Data:",
    choices = c(
      "iris", "mtcars", "economics", 
      "midwest", "mpg", "msleep", "diamonds",
      "faithfuld", "txhousing"
    ),
    inline = TRUE
  ),
  
  fluidRow(
    column(
      width = 3,
      filterDF_UI("filtering")
    ),
    column(
      width = 9,
      progressBar(
        id = "pbar", value = 100, 
        total = 100, display_pct = TRUE
      ),
      DT::dataTableOutput(outputId = "table"),
      tags$p("Code dplyr:"),
      verbatimTextOutput(outputId = "code_dplyr"),
      tags$p("Expression:"),
      verbatimTextOutput(outputId = "code"),
      tags$p("Filtered data:"),
      verbatimTextOutput(outputId = "res_str")
    )
  )
)

server <- function(input, output, session) {
  
  data <- reactive({
    get(input$dataset)
  })
  
  res_filter <- callModule(
    module = filterDF, 
    id = "filtering", 
    data_table = data,
    data_name = reactive(input$dataset)
  )
  
  observeEvent(res_filter$data_filtered(), {
    updateProgressBar(
      session = session, id = "pbar", 
      value = nrow(res_filter$data_filtered()), total = nrow(data())
    )
  })
  
  output$table <- DT::renderDT({
    res_filter$data_filtered()
  }, options = list(pageLength = 5))
  
  
  output$code_dplyr <- renderPrint({
    res_filter$code$dplyr
  })
  output$code <- renderPrint({
    res_filter$code$expr
  })
  
  output$res_str <- renderPrint({
    str(res_filter$data_filtered())
  })
  
}

shinyApp(ui, server)

}
}
