% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-drop.R
\name{dropInput}
\alias{dropInput}
\title{Dropdown Input}
\usage{
dropInput(
  inputId,
  choicesNames,
  choicesValues,
  selected = NULL,
  dropUp = FALSE,
  dropWidth = NULL,
  dropMaxHeight = NULL,
  dropPreScrollable = FALSE,
  btnClass = "btn-link",
  width = NULL
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{choicesNames}{A \code{tagList} of HTML tags to show in the dropdown menu.}

\item{choicesValues}{Vector corresponding to \code{choicesNames}
for retrieving values server-side.}

\item{selected}{The initial selected value, must be an element of \code{choicesValues},
default to the first item of \code{choicesValues}.}

\item{dropUp}{Open the menu above the button rather than below.}

\item{dropWidth}{Width of the dropdown menu.}

\item{dropMaxHeight}{Maximal height for the menu.}

\item{dropPreScrollable}{Force scroll bar to appear in the menu.}

\item{btnClass}{Class for buttons in dropdown menu, default is \code{"btn-link"},
you can use for example \code{"btn-default"} to display regular buttons.}

\item{width}{The width of the input.}
}
\description{
A dropdown menu for selecting a value.
}
\examples{
if (interactive()) {
  
  library(shiny)
  library(esquisse)
  
  ui <- fluidPage(
    tags$h2("Drop Input"),
    dropInput(
      inputId = "mydrop",
      choicesNames = tagList(
        list(icon("home"), style = "width: 100px;"), 
        list(icon("flash"), style = "width: 100px;"),
        list(icon("cogs"), style = "width: 100px;"),
        list(icon("fire"), style = "width: 100px;"), 
        list(icon("users"), style = "width: 100px;"), 
        list(icon("info"), style = "width: 100px;")
      ), 
      choicesValues = c("home", "flash", "cogs",
                        "fire", "users", "info"),
      dropWidth = "220px"
    ),
    verbatimTextOutput(outputId = "res")
  )
  
  server <- function(input, output, session) {
    output$res <- renderPrint({
      input$mydrop
    })
  }
  
  shinyApp(ui, server)
  
}
}
\seealso{
\code{\link{updateDropInput}}
}
